﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SSOAdmin
{
namespace Model
{

  /**
   * <p>A structure that describes a trusted token issuer and associates it with a
   * set of authorized audiences.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AuthorizedTokenIssuer">AWS
   * API Reference</a></p>
   */
  class AuthorizedTokenIssuer
  {
  public:
    AWS_SSOADMIN_API AuthorizedTokenIssuer() = default;
    AWS_SSOADMIN_API AuthorizedTokenIssuer(Aws::Utils::Json::JsonView jsonValue);
    AWS_SSOADMIN_API AuthorizedTokenIssuer& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SSOADMIN_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An array list of authorized audiences, or applications, that can consume the
     * tokens generated by the associated trusted token issuer.</p>
     */
    inline const Aws::Vector<Aws::String>& GetAuthorizedAudiences() const { return m_authorizedAudiences; }
    inline bool AuthorizedAudiencesHasBeenSet() const { return m_authorizedAudiencesHasBeenSet; }
    template<typename AuthorizedAudiencesT = Aws::Vector<Aws::String>>
    void SetAuthorizedAudiences(AuthorizedAudiencesT&& value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences = std::forward<AuthorizedAudiencesT>(value); }
    template<typename AuthorizedAudiencesT = Aws::Vector<Aws::String>>
    AuthorizedTokenIssuer& WithAuthorizedAudiences(AuthorizedAudiencesT&& value) { SetAuthorizedAudiences(std::forward<AuthorizedAudiencesT>(value)); return *this;}
    template<typename AuthorizedAudiencesT = Aws::String>
    AuthorizedTokenIssuer& AddAuthorizedAudiences(AuthorizedAudiencesT&& value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences.emplace_back(std::forward<AuthorizedAudiencesT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The ARN of the trusted token issuer.</p>
     */
    inline const Aws::String& GetTrustedTokenIssuerArn() const { return m_trustedTokenIssuerArn; }
    inline bool TrustedTokenIssuerArnHasBeenSet() const { return m_trustedTokenIssuerArnHasBeenSet; }
    template<typename TrustedTokenIssuerArnT = Aws::String>
    void SetTrustedTokenIssuerArn(TrustedTokenIssuerArnT&& value) { m_trustedTokenIssuerArnHasBeenSet = true; m_trustedTokenIssuerArn = std::forward<TrustedTokenIssuerArnT>(value); }
    template<typename TrustedTokenIssuerArnT = Aws::String>
    AuthorizedTokenIssuer& WithTrustedTokenIssuerArn(TrustedTokenIssuerArnT&& value) { SetTrustedTokenIssuerArn(std::forward<TrustedTokenIssuerArnT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_authorizedAudiences;
    bool m_authorizedAudiencesHasBeenSet = false;

    Aws::String m_trustedTokenIssuerArn;
    bool m_trustedTokenIssuerArnHasBeenSet = false;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
