﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/athena/model/ApplicationDPUSizes.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListApplicationDPUSizesResult
  {
  public:
    AWS_ATHENA_API ListApplicationDPUSizesResult() = default;
    AWS_ATHENA_API ListApplicationDPUSizesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListApplicationDPUSizesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of the supported DPU sizes that the application runtime supports.</p>
     */
    inline const Aws::Vector<ApplicationDPUSizes>& GetApplicationDPUSizes() const { return m_applicationDPUSizes; }
    template<typename ApplicationDPUSizesT = Aws::Vector<ApplicationDPUSizes>>
    void SetApplicationDPUSizes(ApplicationDPUSizesT&& value) { m_applicationDPUSizesHasBeenSet = true; m_applicationDPUSizes = std::forward<ApplicationDPUSizesT>(value); }
    template<typename ApplicationDPUSizesT = Aws::Vector<ApplicationDPUSizes>>
    ListApplicationDPUSizesResult& WithApplicationDPUSizes(ApplicationDPUSizesT&& value) { SetApplicationDPUSizes(std::forward<ApplicationDPUSizesT>(value)); return *this;}
    template<typename ApplicationDPUSizesT = ApplicationDPUSizes>
    ListApplicationDPUSizesResult& AddApplicationDPUSizes(ApplicationDPUSizesT&& value) { m_applicationDPUSizesHasBeenSet = true; m_applicationDPUSizes.emplace_back(std::forward<ApplicationDPUSizesT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListApplicationDPUSizesResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListApplicationDPUSizesResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<ApplicationDPUSizes> m_applicationDPUSizes;
    bool m_applicationDPUSizesHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
