﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{
  class CreateMalwareProtectionPlanResult
  {
  public:
    AWS_GUARDDUTY_API CreateMalwareProtectionPlanResult() = default;
    AWS_GUARDDUTY_API CreateMalwareProtectionPlanResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GUARDDUTY_API CreateMalwareProtectionPlanResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A unique identifier associated with the Malware Protection plan resource.</p>
     */
    inline const Aws::String& GetMalwareProtectionPlanId() const { return m_malwareProtectionPlanId; }
    template<typename MalwareProtectionPlanIdT = Aws::String>
    void SetMalwareProtectionPlanId(MalwareProtectionPlanIdT&& value) { m_malwareProtectionPlanIdHasBeenSet = true; m_malwareProtectionPlanId = std::forward<MalwareProtectionPlanIdT>(value); }
    template<typename MalwareProtectionPlanIdT = Aws::String>
    CreateMalwareProtectionPlanResult& WithMalwareProtectionPlanId(MalwareProtectionPlanIdT&& value) { SetMalwareProtectionPlanId(std::forward<MalwareProtectionPlanIdT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    CreateMalwareProtectionPlanResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_malwareProtectionPlanId;
    bool m_malwareProtectionPlanIdHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
