﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/qconnect/QConnect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace QConnect
{
namespace Model
{
  enum class ConversationStatus
  {
    NOT_SET,
    CLOSED,
    READY,
    PROCESSING
  };

namespace ConversationStatusMapper
{
AWS_QCONNECT_API ConversationStatus GetConversationStatusForName(const Aws::String& name);

AWS_QCONNECT_API Aws::String GetNameForConversationStatus(ConversationStatus value);
} // namespace ConversationStatusMapper
} // namespace Model
} // namespace QConnect
} // namespace Aws
