﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace BedrockAgentRuntime
{
namespace Model
{
  enum class FlowNodeInputCategory
  {
    NOT_SET,
    LoopCondition,
    ReturnValueToLoopStart,
    ExitLoop
  };

namespace FlowNodeInputCategoryMapper
{
AWS_BEDROCKAGENTRUNTIME_API FlowNodeInputCategory GetFlowNodeInputCategoryForName(const Aws::String& name);

AWS_BEDROCKAGENTRUNTIME_API Aws::String GetNameForFlowNodeInputCategory(FlowNodeInputCategory value);
} // namespace FlowNodeInputCategoryMapper
} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
