﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/logs/CloudWatchLogs_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/logs/model/AnomalyDetector.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CloudWatchLogs
{
namespace Model
{
  class ListLogAnomalyDetectorsResult
  {
  public:
    AWS_CLOUDWATCHLOGS_API ListLogAnomalyDetectorsResult() = default;
    AWS_CLOUDWATCHLOGS_API ListLogAnomalyDetectorsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CLOUDWATCHLOGS_API ListLogAnomalyDetectorsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An array of structures, where each structure in the array contains
     * information about one anomaly detector.</p>
     */
    inline const Aws::Vector<AnomalyDetector>& GetAnomalyDetectors() const { return m_anomalyDetectors; }
    template<typename AnomalyDetectorsT = Aws::Vector<AnomalyDetector>>
    void SetAnomalyDetectors(AnomalyDetectorsT&& value) { m_anomalyDetectorsHasBeenSet = true; m_anomalyDetectors = std::forward<AnomalyDetectorsT>(value); }
    template<typename AnomalyDetectorsT = Aws::Vector<AnomalyDetector>>
    ListLogAnomalyDetectorsResult& WithAnomalyDetectors(AnomalyDetectorsT&& value) { SetAnomalyDetectors(std::forward<AnomalyDetectorsT>(value)); return *this;}
    template<typename AnomalyDetectorsT = AnomalyDetector>
    ListLogAnomalyDetectorsResult& AddAnomalyDetectors(AnomalyDetectorsT&& value) { m_anomalyDetectorsHasBeenSet = true; m_anomalyDetectors.emplace_back(std::forward<AnomalyDetectorsT>(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListLogAnomalyDetectorsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListLogAnomalyDetectorsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<AnomalyDetector> m_anomalyDetectors;
    bool m_anomalyDetectorsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudWatchLogs
} // namespace Aws
