﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/cleanroomsml/model/TrainedModelInferenceJobSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CleanRoomsML
{
namespace Model
{
  class ListTrainedModelInferenceJobsResult
  {
  public:
    AWS_CLEANROOMSML_API ListTrainedModelInferenceJobsResult() = default;
    AWS_CLEANROOMSML_API ListTrainedModelInferenceJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CLEANROOMSML_API ListTrainedModelInferenceJobsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The token value used to access the next page of results.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListTrainedModelInferenceJobsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Returns the requested trained model inference jobs.</p>
     */
    inline const Aws::Vector<TrainedModelInferenceJobSummary>& GetTrainedModelInferenceJobs() const { return m_trainedModelInferenceJobs; }
    template<typename TrainedModelInferenceJobsT = Aws::Vector<TrainedModelInferenceJobSummary>>
    void SetTrainedModelInferenceJobs(TrainedModelInferenceJobsT&& value) { m_trainedModelInferenceJobsHasBeenSet = true; m_trainedModelInferenceJobs = std::forward<TrainedModelInferenceJobsT>(value); }
    template<typename TrainedModelInferenceJobsT = Aws::Vector<TrainedModelInferenceJobSummary>>
    ListTrainedModelInferenceJobsResult& WithTrainedModelInferenceJobs(TrainedModelInferenceJobsT&& value) { SetTrainedModelInferenceJobs(std::forward<TrainedModelInferenceJobsT>(value)); return *this;}
    template<typename TrainedModelInferenceJobsT = TrainedModelInferenceJobSummary>
    ListTrainedModelInferenceJobsResult& AddTrainedModelInferenceJobs(TrainedModelInferenceJobsT&& value) { m_trainedModelInferenceJobsHasBeenSet = true; m_trainedModelInferenceJobs.emplace_back(std::forward<TrainedModelInferenceJobsT>(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListTrainedModelInferenceJobsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::Vector<TrainedModelInferenceJobSummary> m_trainedModelInferenceJobs;
    bool m_trainedModelInferenceJobsHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace CleanRoomsML
} // namespace Aws
