﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fsx/FSx_EXPORTS.h>
#include <aws/fsx/model/StorageVirtualMachine.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace FSx {
namespace Model {
class UpdateStorageVirtualMachineResult {
 public:
  AWS_FSX_API UpdateStorageVirtualMachineResult() = default;
  AWS_FSX_API UpdateStorageVirtualMachineResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FSX_API UpdateStorageVirtualMachineResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const StorageVirtualMachine& GetStorageVirtualMachine() const { return m_storageVirtualMachine; }
  template <typename StorageVirtualMachineT = StorageVirtualMachine>
  void SetStorageVirtualMachine(StorageVirtualMachineT&& value) {
    m_storageVirtualMachineHasBeenSet = true;
    m_storageVirtualMachine = std::forward<StorageVirtualMachineT>(value);
  }
  template <typename StorageVirtualMachineT = StorageVirtualMachine>
  UpdateStorageVirtualMachineResult& WithStorageVirtualMachine(StorageVirtualMachineT&& value) {
    SetStorageVirtualMachine(std::forward<StorageVirtualMachineT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateStorageVirtualMachineResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  StorageVirtualMachine m_storageVirtualMachine;
  bool m_storageVirtualMachineHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FSx
}  // namespace Aws
