﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/GlueRequest.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/TimestampFilter.h>

#include <utility>

namespace Aws {
namespace Glue {
namespace Model {

/**
 */
class ListDataQualityStatisticAnnotationsRequest : public GlueRequest {
 public:
  AWS_GLUE_API ListDataQualityStatisticAnnotationsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListDataQualityStatisticAnnotations"; }

  AWS_GLUE_API Aws::String SerializePayload() const override;

  AWS_GLUE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Statistic ID.</p>
   */
  inline const Aws::String& GetStatisticId() const { return m_statisticId; }
  inline bool StatisticIdHasBeenSet() const { return m_statisticIdHasBeenSet; }
  template <typename StatisticIdT = Aws::String>
  void SetStatisticId(StatisticIdT&& value) {
    m_statisticIdHasBeenSet = true;
    m_statisticId = std::forward<StatisticIdT>(value);
  }
  template <typename StatisticIdT = Aws::String>
  ListDataQualityStatisticAnnotationsRequest& WithStatisticId(StatisticIdT&& value) {
    SetStatisticId(std::forward<StatisticIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Profile ID.</p>
   */
  inline const Aws::String& GetProfileId() const { return m_profileId; }
  inline bool ProfileIdHasBeenSet() const { return m_profileIdHasBeenSet; }
  template <typename ProfileIdT = Aws::String>
  void SetProfileId(ProfileIdT&& value) {
    m_profileIdHasBeenSet = true;
    m_profileId = std::forward<ProfileIdT>(value);
  }
  template <typename ProfileIdT = Aws::String>
  ListDataQualityStatisticAnnotationsRequest& WithProfileId(ProfileIdT&& value) {
    SetProfileId(std::forward<ProfileIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp filter.</p>
   */
  inline const TimestampFilter& GetTimestampFilter() const { return m_timestampFilter; }
  inline bool TimestampFilterHasBeenSet() const { return m_timestampFilterHasBeenSet; }
  template <typename TimestampFilterT = TimestampFilter>
  void SetTimestampFilter(TimestampFilterT&& value) {
    m_timestampFilterHasBeenSet = true;
    m_timestampFilter = std::forward<TimestampFilterT>(value);
  }
  template <typename TimestampFilterT = TimestampFilter>
  ListDataQualityStatisticAnnotationsRequest& WithTimestampFilter(TimestampFilterT&& value) {
    SetTimestampFilter(std::forward<TimestampFilterT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to return in this request.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListDataQualityStatisticAnnotationsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A pagination token to retrieve the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDataQualityStatisticAnnotationsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_statisticId;
  bool m_statisticIdHasBeenSet = false;

  Aws::String m_profileId;
  bool m_profileIdHasBeenSet = false;

  TimestampFilter m_timestampFilter;
  bool m_timestampFilterHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
