﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMakerRequest.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/UserSettings.h>

#include <utility>

namespace Aws {
namespace SageMaker {
namespace Model {

/**
 */
class UpdateUserProfileRequest : public SageMakerRequest {
 public:
  AWS_SAGEMAKER_API UpdateUserProfileRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateUserProfile"; }

  AWS_SAGEMAKER_API Aws::String SerializePayload() const override;

  AWS_SAGEMAKER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The domain ID.</p>
   */
  inline const Aws::String& GetDomainId() const { return m_domainId; }
  inline bool DomainIdHasBeenSet() const { return m_domainIdHasBeenSet; }
  template <typename DomainIdT = Aws::String>
  void SetDomainId(DomainIdT&& value) {
    m_domainIdHasBeenSet = true;
    m_domainId = std::forward<DomainIdT>(value);
  }
  template <typename DomainIdT = Aws::String>
  UpdateUserProfileRequest& WithDomainId(DomainIdT&& value) {
    SetDomainId(std::forward<DomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user profile name.</p>
   */
  inline const Aws::String& GetUserProfileName() const { return m_userProfileName; }
  inline bool UserProfileNameHasBeenSet() const { return m_userProfileNameHasBeenSet; }
  template <typename UserProfileNameT = Aws::String>
  void SetUserProfileName(UserProfileNameT&& value) {
    m_userProfileNameHasBeenSet = true;
    m_userProfileName = std::forward<UserProfileNameT>(value);
  }
  template <typename UserProfileNameT = Aws::String>
  UpdateUserProfileRequest& WithUserProfileName(UserProfileNameT&& value) {
    SetUserProfileName(std::forward<UserProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A collection of settings.</p>
   */
  inline const UserSettings& GetUserSettings() const { return m_userSettings; }
  inline bool UserSettingsHasBeenSet() const { return m_userSettingsHasBeenSet; }
  template <typename UserSettingsT = UserSettings>
  void SetUserSettings(UserSettingsT&& value) {
    m_userSettingsHasBeenSet = true;
    m_userSettings = std::forward<UserSettingsT>(value);
  }
  template <typename UserSettingsT = UserSettings>
  UpdateUserProfileRequest& WithUserSettings(UserSettingsT&& value) {
    SetUserSettings(std::forward<UserSettingsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainId;
  bool m_domainIdHasBeenSet = false;

  Aws::String m_userProfileName;
  bool m_userProfileNameHasBeenSet = false;

  UserSettings m_userSettings;
  bool m_userSettingsHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
