﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/signer/SignerRequest.h>
#include <aws/signer/Signer_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace signer {
namespace Model {

/**
 */
class GetSigningProfileRequest : public SignerRequest {
 public:
  AWS_SIGNER_API GetSigningProfileRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetSigningProfile"; }

  AWS_SIGNER_API Aws::String SerializePayload() const override;

  AWS_SIGNER_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the target signing profile.</p>
   */
  inline const Aws::String& GetProfileName() const { return m_profileName; }
  inline bool ProfileNameHasBeenSet() const { return m_profileNameHasBeenSet; }
  template <typename ProfileNameT = Aws::String>
  void SetProfileName(ProfileNameT&& value) {
    m_profileNameHasBeenSet = true;
    m_profileName = std::forward<ProfileNameT>(value);
  }
  template <typename ProfileNameT = Aws::String>
  GetSigningProfileRequest& WithProfileName(ProfileNameT&& value) {
    SetProfileName(std::forward<ProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The AWS account ID of the profile owner.</p>
   */
  inline const Aws::String& GetProfileOwner() const { return m_profileOwner; }
  inline bool ProfileOwnerHasBeenSet() const { return m_profileOwnerHasBeenSet; }
  template <typename ProfileOwnerT = Aws::String>
  void SetProfileOwner(ProfileOwnerT&& value) {
    m_profileOwnerHasBeenSet = true;
    m_profileOwner = std::forward<ProfileOwnerT>(value);
  }
  template <typename ProfileOwnerT = Aws::String>
  GetSigningProfileRequest& WithProfileOwner(ProfileOwnerT&& value) {
    SetProfileOwner(std::forward<ProfileOwnerT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_profileName;
  bool m_profileNameHasBeenSet = false;

  Aws::String m_profileOwner;
  bool m_profileOwnerHasBeenSet = false;
};

}  // namespace Model
}  // namespace signer
}  // namespace Aws
