﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/comprehend/Comprehend_EXPORTS.h>
#include <aws/comprehend/model/DatasetStatus.h>
#include <aws/comprehend/model/DatasetType.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Comprehend {
namespace Model {

/**
 * <p>Properties associated with the dataset.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DatasetProperties">AWS
 * API Reference</a></p>
 */
class DatasetProperties {
 public:
  AWS_COMPREHEND_API DatasetProperties() = default;
  AWS_COMPREHEND_API DatasetProperties(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPREHEND_API DatasetProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPREHEND_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the dataset.</p>
   */
  inline const Aws::String& GetDatasetArn() const { return m_datasetArn; }
  inline bool DatasetArnHasBeenSet() const { return m_datasetArnHasBeenSet; }
  template <typename DatasetArnT = Aws::String>
  void SetDatasetArn(DatasetArnT&& value) {
    m_datasetArnHasBeenSet = true;
    m_datasetArn = std::forward<DatasetArnT>(value);
  }
  template <typename DatasetArnT = Aws::String>
  DatasetProperties& WithDatasetArn(DatasetArnT&& value) {
    SetDatasetArn(std::forward<DatasetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the dataset.</p>
   */
  inline const Aws::String& GetDatasetName() const { return m_datasetName; }
  inline bool DatasetNameHasBeenSet() const { return m_datasetNameHasBeenSet; }
  template <typename DatasetNameT = Aws::String>
  void SetDatasetName(DatasetNameT&& value) {
    m_datasetNameHasBeenSet = true;
    m_datasetName = std::forward<DatasetNameT>(value);
  }
  template <typename DatasetNameT = Aws::String>
  DatasetProperties& WithDatasetName(DatasetNameT&& value) {
    SetDatasetName(std::forward<DatasetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The dataset type (training data or test data).</p>
   */
  inline DatasetType GetDatasetType() const { return m_datasetType; }
  inline bool DatasetTypeHasBeenSet() const { return m_datasetTypeHasBeenSet; }
  inline void SetDatasetType(DatasetType value) {
    m_datasetTypeHasBeenSet = true;
    m_datasetType = value;
  }
  inline DatasetProperties& WithDatasetType(DatasetType value) {
    SetDatasetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The S3 URI where the dataset is stored.</p>
   */
  inline const Aws::String& GetDatasetS3Uri() const { return m_datasetS3Uri; }
  inline bool DatasetS3UriHasBeenSet() const { return m_datasetS3UriHasBeenSet; }
  template <typename DatasetS3UriT = Aws::String>
  void SetDatasetS3Uri(DatasetS3UriT&& value) {
    m_datasetS3UriHasBeenSet = true;
    m_datasetS3Uri = std::forward<DatasetS3UriT>(value);
  }
  template <typename DatasetS3UriT = Aws::String>
  DatasetProperties& WithDatasetS3Uri(DatasetS3UriT&& value) {
    SetDatasetS3Uri(std::forward<DatasetS3UriT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Description of the dataset.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DatasetProperties& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The dataset status. While the system creates the dataset, the status is
   * <code>CREATING</code>. When the dataset is ready to use, the status changes to
   * <code>COMPLETED</code>. </p>
   */
  inline DatasetStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(DatasetStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DatasetProperties& WithStatus(DatasetStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the status of the dataset.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  DatasetProperties& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of documents in the dataset.</p>
   */
  inline long long GetNumberOfDocuments() const { return m_numberOfDocuments; }
  inline bool NumberOfDocumentsHasBeenSet() const { return m_numberOfDocumentsHasBeenSet; }
  inline void SetNumberOfDocuments(long long value) {
    m_numberOfDocumentsHasBeenSet = true;
    m_numberOfDocuments = value;
  }
  inline DatasetProperties& WithNumberOfDocuments(long long value) {
    SetNumberOfDocuments(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Creation time of the dataset.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DatasetProperties& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Time when the data from the dataset becomes available in the data lake.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  inline bool EndTimeHasBeenSet() const { return m_endTimeHasBeenSet; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  DatasetProperties& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_datasetArn;
  bool m_datasetArnHasBeenSet = false;

  Aws::String m_datasetName;
  bool m_datasetNameHasBeenSet = false;

  DatasetType m_datasetType{DatasetType::NOT_SET};
  bool m_datasetTypeHasBeenSet = false;

  Aws::String m_datasetS3Uri;
  bool m_datasetS3UriHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  DatasetStatus m_status{DatasetStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;

  long long m_numberOfDocuments{0};
  bool m_numberOfDocumentsHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::Utils::DateTime m_endTime{};
  bool m_endTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Comprehend
}  // namespace Aws
