﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/cost-optimization-hub/CostOptimizationHub_EXPORTS.h>
#include <aws/cost-optimization-hub/model/Order.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CostOptimizationHub {
namespace Model {

/**
 * <p>Defines how rows will be sorted in the response.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/OrderBy">AWS
 * API Reference</a></p>
 */
class OrderBy {
 public:
  AWS_COSTOPTIMIZATIONHUB_API OrderBy() = default;
  AWS_COSTOPTIMIZATIONHUB_API OrderBy(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTOPTIMIZATIONHUB_API OrderBy& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTOPTIMIZATIONHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Sorts by dimension values.</p>
   */
  inline const Aws::String& GetDimension() const { return m_dimension; }
  inline bool DimensionHasBeenSet() const { return m_dimensionHasBeenSet; }
  template <typename DimensionT = Aws::String>
  void SetDimension(DimensionT&& value) {
    m_dimensionHasBeenSet = true;
    m_dimension = std::forward<DimensionT>(value);
  }
  template <typename DimensionT = Aws::String>
  OrderBy& WithDimension(DimensionT&& value) {
    SetDimension(std::forward<DimensionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The order that's used to sort the data.</p>
   */
  inline Order GetOrder() const { return m_order; }
  inline bool OrderHasBeenSet() const { return m_orderHasBeenSet; }
  inline void SetOrder(Order value) {
    m_orderHasBeenSet = true;
    m_order = value;
  }
  inline OrderBy& WithOrder(Order value) {
    SetOrder(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_dimension;
  bool m_dimensionHasBeenSet = false;

  Order m_order{Order::NOT_SET};
  bool m_orderHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostOptimizationHub
}  // namespace Aws
