﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/greengrass/GreengrassRequest.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Greengrass {
namespace Model {

/**
 */
class ListCoreDefinitionVersionsRequest : public GreengrassRequest {
 public:
  AWS_GREENGRASS_API ListCoreDefinitionVersionsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListCoreDefinitionVersions"; }

  AWS_GREENGRASS_API Aws::String SerializePayload() const override;

  AWS_GREENGRASS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * The ID of the core definition.
   */
  inline const Aws::String& GetCoreDefinitionId() const { return m_coreDefinitionId; }
  inline bool CoreDefinitionIdHasBeenSet() const { return m_coreDefinitionIdHasBeenSet; }
  template <typename CoreDefinitionIdT = Aws::String>
  void SetCoreDefinitionId(CoreDefinitionIdT&& value) {
    m_coreDefinitionIdHasBeenSet = true;
    m_coreDefinitionId = std::forward<CoreDefinitionIdT>(value);
  }
  template <typename CoreDefinitionIdT = Aws::String>
  ListCoreDefinitionVersionsRequest& WithCoreDefinitionId(CoreDefinitionIdT&& value) {
    SetCoreDefinitionId(std::forward<CoreDefinitionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The maximum number of results to be returned per request.
   */
  inline const Aws::String& GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  template <typename MaxResultsT = Aws::String>
  void SetMaxResults(MaxResultsT&& value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = std::forward<MaxResultsT>(value);
  }
  template <typename MaxResultsT = Aws::String>
  ListCoreDefinitionVersionsRequest& WithMaxResults(MaxResultsT&& value) {
    SetMaxResults(std::forward<MaxResultsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The token for the next set of results, or ''null'' if there are no additional
   * results.
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCoreDefinitionVersionsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_coreDefinitionId;
  bool m_coreDefinitionIdHasBeenSet = false;

  Aws::String m_maxResults;
  bool m_maxResultsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
