﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/groundstation/GroundStation_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GroundStation {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/MissionProfileIdResponse">AWS
 * API Reference</a></p>
 */
class UpdateMissionProfileResult {
 public:
  AWS_GROUNDSTATION_API UpdateMissionProfileResult() = default;
  AWS_GROUNDSTATION_API UpdateMissionProfileResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GROUNDSTATION_API UpdateMissionProfileResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>UUID of a mission profile.</p>
   */
  inline const Aws::String& GetMissionProfileId() const { return m_missionProfileId; }
  template <typename MissionProfileIdT = Aws::String>
  void SetMissionProfileId(MissionProfileIdT&& value) {
    m_missionProfileIdHasBeenSet = true;
    m_missionProfileId = std::forward<MissionProfileIdT>(value);
  }
  template <typename MissionProfileIdT = Aws::String>
  UpdateMissionProfileResult& WithMissionProfileId(MissionProfileIdT&& value) {
    SetMissionProfileId(std::forward<MissionProfileIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateMissionProfileResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_missionProfileId;
  bool m_missionProfileIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GroundStation
}  // namespace Aws
