﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/BatchPutAssetPropertyError.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {

/**
 * <p>Contains error information for asset property value entries that are
 * associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html">BatchPutAssetPropertyValue</a>
 * API.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyErrorEntry">AWS
 * API Reference</a></p>
 */
class BatchPutAssetPropertyErrorEntry {
 public:
  AWS_IOTSITEWISE_API BatchPutAssetPropertyErrorEntry() = default;
  AWS_IOTSITEWISE_API BatchPutAssetPropertyErrorEntry(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API BatchPutAssetPropertyErrorEntry& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the failed entry.</p>
   */
  inline const Aws::String& GetEntryId() const { return m_entryId; }
  inline bool EntryIdHasBeenSet() const { return m_entryIdHasBeenSet; }
  template <typename EntryIdT = Aws::String>
  void SetEntryId(EntryIdT&& value) {
    m_entryIdHasBeenSet = true;
    m_entryId = std::forward<EntryIdT>(value);
  }
  template <typename EntryIdT = Aws::String>
  BatchPutAssetPropertyErrorEntry& WithEntryId(EntryIdT&& value) {
    SetEntryId(std::forward<EntryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of update property value errors.</p>
   */
  inline const Aws::Vector<BatchPutAssetPropertyError>& GetErrors() const { return m_errors; }
  inline bool ErrorsHasBeenSet() const { return m_errorsHasBeenSet; }
  template <typename ErrorsT = Aws::Vector<BatchPutAssetPropertyError>>
  void SetErrors(ErrorsT&& value) {
    m_errorsHasBeenSet = true;
    m_errors = std::forward<ErrorsT>(value);
  }
  template <typename ErrorsT = Aws::Vector<BatchPutAssetPropertyError>>
  BatchPutAssetPropertyErrorEntry& WithErrors(ErrorsT&& value) {
    SetErrors(std::forward<ErrorsT>(value));
    return *this;
  }
  template <typename ErrorsT = BatchPutAssetPropertyError>
  BatchPutAssetPropertyErrorEntry& AddErrors(ErrorsT&& value) {
    m_errorsHasBeenSet = true;
    m_errors.emplace_back(std::forward<ErrorsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_entryId;
  bool m_entryIdHasBeenSet = false;

  Aws::Vector<BatchPutAssetPropertyError> m_errors;
  bool m_errorsHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
