﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptune-graph/NeptuneGraph_EXPORTS.h>
#include <aws/neptune-graph/model/ExportFormat.h>
#include <aws/neptune-graph/model/ExportTaskStatus.h>
#include <aws/neptune-graph/model/ParquetType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace NeptuneGraph {
namespace Model {

/**
 * <p>Provides details about an export task.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExportTaskSummary">AWS
 * API Reference</a></p>
 */
class ExportTaskSummary {
 public:
  AWS_NEPTUNEGRAPH_API ExportTaskSummary() = default;
  AWS_NEPTUNEGRAPH_API ExportTaskSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_NEPTUNEGRAPH_API ExportTaskSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_NEPTUNEGRAPH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The source graph identifier of the export task.</p>
   */
  inline const Aws::String& GetGraphId() const { return m_graphId; }
  inline bool GraphIdHasBeenSet() const { return m_graphIdHasBeenSet; }
  template <typename GraphIdT = Aws::String>
  void SetGraphId(GraphIdT&& value) {
    m_graphIdHasBeenSet = true;
    m_graphId = std::forward<GraphIdT>(value);
  }
  template <typename GraphIdT = Aws::String>
  ExportTaskSummary& WithGraphId(GraphIdT&& value) {
    SetGraphId(std::forward<GraphIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the IAM role that will allow the data to be exported to the
   * destination.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  ExportTaskSummary& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the export task.</p>
   */
  inline const Aws::String& GetTaskId() const { return m_taskId; }
  inline bool TaskIdHasBeenSet() const { return m_taskIdHasBeenSet; }
  template <typename TaskIdT = Aws::String>
  void SetTaskId(TaskIdT&& value) {
    m_taskIdHasBeenSet = true;
    m_taskId = std::forward<TaskIdT>(value);
  }
  template <typename TaskIdT = Aws::String>
  ExportTaskSummary& WithTaskId(TaskIdT&& value) {
    SetTaskId(std::forward<TaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the export task.</p>
   */
  inline ExportTaskStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ExportTaskStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ExportTaskSummary& WithStatus(ExportTaskStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The format of the export task.</p>
   */
  inline ExportFormat GetFormat() const { return m_format; }
  inline bool FormatHasBeenSet() const { return m_formatHasBeenSet; }
  inline void SetFormat(ExportFormat value) {
    m_formatHasBeenSet = true;
    m_format = value;
  }
  inline ExportTaskSummary& WithFormat(ExportFormat value) {
    SetFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon S3 URI of the export task where data will be exported to.</p>
   */
  inline const Aws::String& GetDestination() const { return m_destination; }
  inline bool DestinationHasBeenSet() const { return m_destinationHasBeenSet; }
  template <typename DestinationT = Aws::String>
  void SetDestination(DestinationT&& value) {
    m_destinationHasBeenSet = true;
    m_destination = std::forward<DestinationT>(value);
  }
  template <typename DestinationT = Aws::String>
  ExportTaskSummary& WithDestination(DestinationT&& value) {
    SetDestination(std::forward<DestinationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The KMS key identifier of the export task.</p>
   */
  inline const Aws::String& GetKmsKeyIdentifier() const { return m_kmsKeyIdentifier; }
  inline bool KmsKeyIdentifierHasBeenSet() const { return m_kmsKeyIdentifierHasBeenSet; }
  template <typename KmsKeyIdentifierT = Aws::String>
  void SetKmsKeyIdentifier(KmsKeyIdentifierT&& value) {
    m_kmsKeyIdentifierHasBeenSet = true;
    m_kmsKeyIdentifier = std::forward<KmsKeyIdentifierT>(value);
  }
  template <typename KmsKeyIdentifierT = Aws::String>
  ExportTaskSummary& WithKmsKeyIdentifier(KmsKeyIdentifierT&& value) {
    SetKmsKeyIdentifier(std::forward<KmsKeyIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The parquet type of the export task.</p>
   */
  inline ParquetType GetParquetType() const { return m_parquetType; }
  inline bool ParquetTypeHasBeenSet() const { return m_parquetTypeHasBeenSet; }
  inline void SetParquetType(ParquetType value) {
    m_parquetTypeHasBeenSet = true;
    m_parquetType = value;
  }
  inline ExportTaskSummary& WithParquetType(ParquetType value) {
    SetParquetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason that the export task has this status value.</p>
   */
  inline const Aws::String& GetStatusReason() const { return m_statusReason; }
  inline bool StatusReasonHasBeenSet() const { return m_statusReasonHasBeenSet; }
  template <typename StatusReasonT = Aws::String>
  void SetStatusReason(StatusReasonT&& value) {
    m_statusReasonHasBeenSet = true;
    m_statusReason = std::forward<StatusReasonT>(value);
  }
  template <typename StatusReasonT = Aws::String>
  ExportTaskSummary& WithStatusReason(StatusReasonT&& value) {
    SetStatusReason(std::forward<StatusReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_graphId;
  bool m_graphIdHasBeenSet = false;

  Aws::String m_roleArn;
  bool m_roleArnHasBeenSet = false;

  Aws::String m_taskId;
  bool m_taskIdHasBeenSet = false;

  ExportTaskStatus m_status{ExportTaskStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  ExportFormat m_format{ExportFormat::NOT_SET};
  bool m_formatHasBeenSet = false;

  Aws::String m_destination;
  bool m_destinationHasBeenSet = false;

  Aws::String m_kmsKeyIdentifier;
  bool m_kmsKeyIdentifierHasBeenSet = false;

  ParquetType m_parquetType{ParquetType::NOT_SET};
  bool m_parquetTypeHasBeenSet = false;

  Aws::String m_statusReason;
  bool m_statusReasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace NeptuneGraph
}  // namespace Aws
