﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/JourneyResponse.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {
class CreateJourneyResult {
 public:
  AWS_PINPOINT_API CreateJourneyResult() = default;
  AWS_PINPOINT_API CreateJourneyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINT_API CreateJourneyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const JourneyResponse& GetJourneyResponse() const { return m_journeyResponse; }
  template <typename JourneyResponseT = JourneyResponse>
  void SetJourneyResponse(JourneyResponseT&& value) {
    m_journeyResponseHasBeenSet = true;
    m_journeyResponse = std::forward<JourneyResponseT>(value);
  }
  template <typename JourneyResponseT = JourneyResponse>
  CreateJourneyResult& WithJourneyResponse(JourneyResponseT&& value) {
    SetJourneyResponse(std::forward<JourneyResponseT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateJourneyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  JourneyResponse m_journeyResponse;
  bool m_journeyResponseHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
