﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/ApplicationsResponse.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {
class GetAppsResult {
 public:
  AWS_PINPOINT_API GetAppsResult() = default;
  AWS_PINPOINT_API GetAppsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINT_API GetAppsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const ApplicationsResponse& GetApplicationsResponse() const { return m_applicationsResponse; }
  template <typename ApplicationsResponseT = ApplicationsResponse>
  void SetApplicationsResponse(ApplicationsResponseT&& value) {
    m_applicationsResponseHasBeenSet = true;
    m_applicationsResponse = std::forward<ApplicationsResponseT>(value);
  }
  template <typename ApplicationsResponseT = ApplicationsResponse>
  GetAppsResult& WithApplicationsResponse(ApplicationsResponseT&& value) {
    SetApplicationsResponse(std::forward<ApplicationsResponseT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetAppsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ApplicationsResponse m_applicationsResponse;
  bool m_applicationsResponseHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
