﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace StorageGateway {
namespace Model {
class CreateSnapshotFromVolumeRecoveryPointResult {
 public:
  AWS_STORAGEGATEWAY_API CreateSnapshotFromVolumeRecoveryPointResult() = default;
  AWS_STORAGEGATEWAY_API CreateSnapshotFromVolumeRecoveryPointResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_STORAGEGATEWAY_API CreateSnapshotFromVolumeRecoveryPointResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the snapshot.</p>
   */
  inline const Aws::String& GetSnapshotId() const { return m_snapshotId; }
  template <typename SnapshotIdT = Aws::String>
  void SetSnapshotId(SnapshotIdT&& value) {
    m_snapshotIdHasBeenSet = true;
    m_snapshotId = std::forward<SnapshotIdT>(value);
  }
  template <typename SnapshotIdT = Aws::String>
  CreateSnapshotFromVolumeRecoveryPointResult& WithSnapshotId(SnapshotIdT&& value) {
    SetSnapshotId(std::forward<SnapshotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
   * <a>DescribeStorediSCSIVolumes</a> operation to return to retrieve the TargetARN
   * for specified VolumeARN.</p>
   */
  inline const Aws::String& GetVolumeARN() const { return m_volumeARN; }
  template <typename VolumeARNT = Aws::String>
  void SetVolumeARN(VolumeARNT&& value) {
    m_volumeARNHasBeenSet = true;
    m_volumeARN = std::forward<VolumeARNT>(value);
  }
  template <typename VolumeARNT = Aws::String>
  CreateSnapshotFromVolumeRecoveryPointResult& WithVolumeARN(VolumeARNT&& value) {
    SetVolumeARN(std::forward<VolumeARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the volume was created from the recovery point.</p>
   */
  inline const Aws::String& GetVolumeRecoveryPointTime() const { return m_volumeRecoveryPointTime; }
  template <typename VolumeRecoveryPointTimeT = Aws::String>
  void SetVolumeRecoveryPointTime(VolumeRecoveryPointTimeT&& value) {
    m_volumeRecoveryPointTimeHasBeenSet = true;
    m_volumeRecoveryPointTime = std::forward<VolumeRecoveryPointTimeT>(value);
  }
  template <typename VolumeRecoveryPointTimeT = Aws::String>
  CreateSnapshotFromVolumeRecoveryPointResult& WithVolumeRecoveryPointTime(VolumeRecoveryPointTimeT&& value) {
    SetVolumeRecoveryPointTime(std::forward<VolumeRecoveryPointTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateSnapshotFromVolumeRecoveryPointResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_snapshotId;
  bool m_snapshotIdHasBeenSet = false;

  Aws::String m_volumeARN;
  bool m_volumeARNHasBeenSet = false;

  Aws::String m_volumeRecoveryPointTime;
  bool m_volumeRecoveryPointTimeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
