﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/Instance.h>
#include <aws/connect/model/ReplicationConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {
class DescribeInstanceResult {
 public:
  AWS_CONNECT_API DescribeInstanceResult() = default;
  AWS_CONNECT_API DescribeInstanceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECT_API DescribeInstanceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the instance.</p>
   */
  inline const Instance& GetInstance() const { return m_instance; }
  template <typename InstanceT = Instance>
  void SetInstance(InstanceT&& value) {
    m_instanceHasBeenSet = true;
    m_instance = std::forward<InstanceT>(value);
  }
  template <typename InstanceT = Instance>
  DescribeInstanceResult& WithInstance(InstanceT&& value) {
    SetInstance(std::forward<InstanceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Status information about the replication process. This field is included only
   * when you are using the <a
   * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">ReplicateInstance</a>
   * API to replicate an Amazon Connect instance across Amazon Web Services Regions.
   * For information about replicating Amazon Connect instances, see <a
   * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html">Create
   * a replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect
   * Administrator Guide</i>.</p>
   */
  inline const ReplicationConfiguration& GetReplicationConfiguration() const { return m_replicationConfiguration; }
  template <typename ReplicationConfigurationT = ReplicationConfiguration>
  void SetReplicationConfiguration(ReplicationConfigurationT&& value) {
    m_replicationConfigurationHasBeenSet = true;
    m_replicationConfiguration = std::forward<ReplicationConfigurationT>(value);
  }
  template <typename ReplicationConfigurationT = ReplicationConfiguration>
  DescribeInstanceResult& WithReplicationConfiguration(ReplicationConfigurationT&& value) {
    SetReplicationConfiguration(std::forward<ReplicationConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeInstanceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Instance m_instance;
  bool m_instanceHasBeenSet = false;

  ReplicationConfiguration m_replicationConfiguration;
  bool m_replicationConfigurationHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
