﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/DeadlineRequest.h>
#include <aws/deadline/Deadline_EXPORTS.h>

#include <utility>

namespace Aws {
namespace deadline {
namespace Model {

/**
 */
class GetStorageProfileRequest : public DeadlineRequest {
 public:
  AWS_DEADLINE_API GetStorageProfileRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetStorageProfile"; }

  AWS_DEADLINE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The farm ID for the storage profile.</p>
   */
  inline const Aws::String& GetFarmId() const { return m_farmId; }
  inline bool FarmIdHasBeenSet() const { return m_farmIdHasBeenSet; }
  template <typename FarmIdT = Aws::String>
  void SetFarmId(FarmIdT&& value) {
    m_farmIdHasBeenSet = true;
    m_farmId = std::forward<FarmIdT>(value);
  }
  template <typename FarmIdT = Aws::String>
  GetStorageProfileRequest& WithFarmId(FarmIdT&& value) {
    SetFarmId(std::forward<FarmIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The storage profile ID.</p>
   */
  inline const Aws::String& GetStorageProfileId() const { return m_storageProfileId; }
  inline bool StorageProfileIdHasBeenSet() const { return m_storageProfileIdHasBeenSet; }
  template <typename StorageProfileIdT = Aws::String>
  void SetStorageProfileId(StorageProfileIdT&& value) {
    m_storageProfileIdHasBeenSet = true;
    m_storageProfileId = std::forward<StorageProfileIdT>(value);
  }
  template <typename StorageProfileIdT = Aws::String>
  GetStorageProfileRequest& WithStorageProfileId(StorageProfileIdT&& value) {
    SetStorageProfileId(std::forward<StorageProfileIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_farmId;
  bool m_farmIdHasBeenSet = false;

  Aws::String m_storageProfileId;
  bool m_storageProfileIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
