﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glacier/Glacier_EXPORTS.h>
#include <aws/glacier/model/Grantee.h>
#include <aws/glacier/model/Permission.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glacier {
namespace Model {

/**
 * <p>Contains information about a grant.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glacier-2012-06-01/Grant">AWS API
 * Reference</a></p>
 */
class Grant {
 public:
  AWS_GLACIER_API Grant() = default;
  AWS_GLACIER_API Grant(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLACIER_API Grant& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLACIER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The grantee.</p>
   */
  inline const Grantee& GetGrantee() const { return m_grantee; }
  inline bool GranteeHasBeenSet() const { return m_granteeHasBeenSet; }
  template <typename GranteeT = Grantee>
  void SetGrantee(GranteeT&& value) {
    m_granteeHasBeenSet = true;
    m_grantee = std::forward<GranteeT>(value);
  }
  template <typename GranteeT = Grantee>
  Grant& WithGrantee(GranteeT&& value) {
    SetGrantee(std::forward<GranteeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the permission given to the grantee. </p>
   */
  inline Permission GetPermission() const { return m_permission; }
  inline bool PermissionHasBeenSet() const { return m_permissionHasBeenSet; }
  inline void SetPermission(Permission value) {
    m_permissionHasBeenSet = true;
    m_permission = value;
  }
  inline Grant& WithPermission(Permission value) {
    SetPermission(value);
    return *this;
  }
  ///@}
 private:
  Grantee m_grantee;
  bool m_granteeHasBeenSet = false;

  Permission m_permission{Permission::NOT_SET};
  bool m_permissionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glacier
}  // namespace Aws
