﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {
class DeleteInfrastructureConfigurationResult {
 public:
  AWS_IMAGEBUILDER_API DeleteInfrastructureConfigurationResult() = default;
  AWS_IMAGEBUILDER_API DeleteInfrastructureConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IMAGEBUILDER_API DeleteInfrastructureConfigurationResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The request ID that uniquely identifies this request.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteInfrastructureConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was
   * deleted.</p>
   */
  inline const Aws::String& GetInfrastructureConfigurationArn() const { return m_infrastructureConfigurationArn; }
  template <typename InfrastructureConfigurationArnT = Aws::String>
  void SetInfrastructureConfigurationArn(InfrastructureConfigurationArnT&& value) {
    m_infrastructureConfigurationArnHasBeenSet = true;
    m_infrastructureConfigurationArn = std::forward<InfrastructureConfigurationArnT>(value);
  }
  template <typename InfrastructureConfigurationArnT = Aws::String>
  DeleteInfrastructureConfigurationResult& WithInfrastructureConfigurationArn(InfrastructureConfigurationArnT&& value) {
    SetInfrastructureConfigurationArn(std::forward<InfrastructureConfigurationArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;

  Aws::String m_infrastructureConfigurationArn;
  bool m_infrastructureConfigurationArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
