﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {

/**
 * <p>Describes a disk.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DiskInfo">AWS
 * API Reference</a></p>
 */
class DiskInfo {
 public:
  AWS_LIGHTSAIL_API DiskInfo() = default;
  AWS_LIGHTSAIL_API DiskInfo(Aws::Utils::Json::JsonView jsonValue);
  AWS_LIGHTSAIL_API DiskInfo& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LIGHTSAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The disk name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DiskInfo& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The disk path.</p>
   */
  inline const Aws::String& GetPath() const { return m_path; }
  inline bool PathHasBeenSet() const { return m_pathHasBeenSet; }
  template <typename PathT = Aws::String>
  void SetPath(PathT&& value) {
    m_pathHasBeenSet = true;
    m_path = std::forward<PathT>(value);
  }
  template <typename PathT = Aws::String>
  DiskInfo& WithPath(PathT&& value) {
    SetPath(std::forward<PathT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The size of the disk in GB (<code>32</code>).</p>
   */
  inline int GetSizeInGb() const { return m_sizeInGb; }
  inline bool SizeInGbHasBeenSet() const { return m_sizeInGbHasBeenSet; }
  inline void SetSizeInGb(int value) {
    m_sizeInGbHasBeenSet = true;
    m_sizeInGb = value;
  }
  inline DiskInfo& WithSizeInGb(int value) {
    SetSizeInGb(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A Boolean value indicating whether this disk is a system disk (has an
   * operating system loaded on it).</p>
   */
  inline bool GetIsSystemDisk() const { return m_isSystemDisk; }
  inline bool IsSystemDiskHasBeenSet() const { return m_isSystemDiskHasBeenSet; }
  inline void SetIsSystemDisk(bool value) {
    m_isSystemDiskHasBeenSet = true;
    m_isSystemDisk = value;
  }
  inline DiskInfo& WithIsSystemDisk(bool value) {
    SetIsSystemDisk(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_path;
  bool m_pathHasBeenSet = false;

  int m_sizeInGb{0};
  bool m_sizeInGbHasBeenSet = false;

  bool m_isSystemDisk{false};
  bool m_isSystemDiskHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
