﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/DimensionField.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The unique values computation configuration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UniqueValuesComputation">AWS
 * API Reference</a></p>
 */
class UniqueValuesComputation {
 public:
  AWS_QUICKSIGHT_API UniqueValuesComputation() = default;
  AWS_QUICKSIGHT_API UniqueValuesComputation(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API UniqueValuesComputation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID for a computation.</p>
   */
  inline const Aws::String& GetComputationId() const { return m_computationId; }
  inline bool ComputationIdHasBeenSet() const { return m_computationIdHasBeenSet; }
  template <typename ComputationIdT = Aws::String>
  void SetComputationId(ComputationIdT&& value) {
    m_computationIdHasBeenSet = true;
    m_computationId = std::forward<ComputationIdT>(value);
  }
  template <typename ComputationIdT = Aws::String>
  UniqueValuesComputation& WithComputationId(ComputationIdT&& value) {
    SetComputationId(std::forward<ComputationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of a computation.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UniqueValuesComputation& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The category field that is used in a computation.</p>
   */
  inline const DimensionField& GetCategory() const { return m_category; }
  inline bool CategoryHasBeenSet() const { return m_categoryHasBeenSet; }
  template <typename CategoryT = DimensionField>
  void SetCategory(CategoryT&& value) {
    m_categoryHasBeenSet = true;
    m_category = std::forward<CategoryT>(value);
  }
  template <typename CategoryT = DimensionField>
  UniqueValuesComputation& WithCategory(CategoryT&& value) {
    SetCategory(std::forward<CategoryT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_computationId;
  bool m_computationIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  DimensionField m_category;
  bool m_categoryHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
