﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/MonitoringType.h>
#include <aws/sagemaker/model/ScheduleStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>Summarizes the monitoring schedule.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MonitoringScheduleSummary">AWS
 * API Reference</a></p>
 */
class MonitoringScheduleSummary {
 public:
  AWS_SAGEMAKER_API MonitoringScheduleSummary() = default;
  AWS_SAGEMAKER_API MonitoringScheduleSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API MonitoringScheduleSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the monitoring schedule.</p>
   */
  inline const Aws::String& GetMonitoringScheduleName() const { return m_monitoringScheduleName; }
  inline bool MonitoringScheduleNameHasBeenSet() const { return m_monitoringScheduleNameHasBeenSet; }
  template <typename MonitoringScheduleNameT = Aws::String>
  void SetMonitoringScheduleName(MonitoringScheduleNameT&& value) {
    m_monitoringScheduleNameHasBeenSet = true;
    m_monitoringScheduleName = std::forward<MonitoringScheduleNameT>(value);
  }
  template <typename MonitoringScheduleNameT = Aws::String>
  MonitoringScheduleSummary& WithMonitoringScheduleName(MonitoringScheduleNameT&& value) {
    SetMonitoringScheduleName(std::forward<MonitoringScheduleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
   */
  inline const Aws::String& GetMonitoringScheduleArn() const { return m_monitoringScheduleArn; }
  inline bool MonitoringScheduleArnHasBeenSet() const { return m_monitoringScheduleArnHasBeenSet; }
  template <typename MonitoringScheduleArnT = Aws::String>
  void SetMonitoringScheduleArn(MonitoringScheduleArnT&& value) {
    m_monitoringScheduleArnHasBeenSet = true;
    m_monitoringScheduleArn = std::forward<MonitoringScheduleArnT>(value);
  }
  template <typename MonitoringScheduleArnT = Aws::String>
  MonitoringScheduleSummary& WithMonitoringScheduleArn(MonitoringScheduleArnT&& value) {
    SetMonitoringScheduleArn(std::forward<MonitoringScheduleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation time of the monitoring schedule.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  MonitoringScheduleSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The last time the monitoring schedule was modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  MonitoringScheduleSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the monitoring schedule.</p>
   */
  inline ScheduleStatus GetMonitoringScheduleStatus() const { return m_monitoringScheduleStatus; }
  inline bool MonitoringScheduleStatusHasBeenSet() const { return m_monitoringScheduleStatusHasBeenSet; }
  inline void SetMonitoringScheduleStatus(ScheduleStatus value) {
    m_monitoringScheduleStatusHasBeenSet = true;
    m_monitoringScheduleStatus = value;
  }
  inline MonitoringScheduleSummary& WithMonitoringScheduleStatus(ScheduleStatus value) {
    SetMonitoringScheduleStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the endpoint using the monitoring schedule.</p>
   */
  inline const Aws::String& GetEndpointName() const { return m_endpointName; }
  inline bool EndpointNameHasBeenSet() const { return m_endpointNameHasBeenSet; }
  template <typename EndpointNameT = Aws::String>
  void SetEndpointName(EndpointNameT&& value) {
    m_endpointNameHasBeenSet = true;
    m_endpointName = std::forward<EndpointNameT>(value);
  }
  template <typename EndpointNameT = Aws::String>
  MonitoringScheduleSummary& WithEndpointName(EndpointNameT&& value) {
    SetEndpointName(std::forward<EndpointNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the monitoring job definition that the schedule is for.</p>
   */
  inline const Aws::String& GetMonitoringJobDefinitionName() const { return m_monitoringJobDefinitionName; }
  inline bool MonitoringJobDefinitionNameHasBeenSet() const { return m_monitoringJobDefinitionNameHasBeenSet; }
  template <typename MonitoringJobDefinitionNameT = Aws::String>
  void SetMonitoringJobDefinitionName(MonitoringJobDefinitionNameT&& value) {
    m_monitoringJobDefinitionNameHasBeenSet = true;
    m_monitoringJobDefinitionName = std::forward<MonitoringJobDefinitionNameT>(value);
  }
  template <typename MonitoringJobDefinitionNameT = Aws::String>
  MonitoringScheduleSummary& WithMonitoringJobDefinitionName(MonitoringJobDefinitionNameT&& value) {
    SetMonitoringJobDefinitionName(std::forward<MonitoringJobDefinitionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the monitoring job definition that the schedule is for.</p>
   */
  inline MonitoringType GetMonitoringType() const { return m_monitoringType; }
  inline bool MonitoringTypeHasBeenSet() const { return m_monitoringTypeHasBeenSet; }
  inline void SetMonitoringType(MonitoringType value) {
    m_monitoringTypeHasBeenSet = true;
    m_monitoringType = value;
  }
  inline MonitoringScheduleSummary& WithMonitoringType(MonitoringType value) {
    SetMonitoringType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_monitoringScheduleName;
  bool m_monitoringScheduleNameHasBeenSet = false;

  Aws::String m_monitoringScheduleArn;
  bool m_monitoringScheduleArnHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  ScheduleStatus m_monitoringScheduleStatus{ScheduleStatus::NOT_SET};
  bool m_monitoringScheduleStatusHasBeenSet = false;

  Aws::String m_endpointName;
  bool m_endpointNameHasBeenSet = false;

  Aws::String m_monitoringJobDefinitionName;
  bool m_monitoringJobDefinitionNameHasBeenSet = false;

  MonitoringType m_monitoringType{MonitoringType::NOT_SET};
  bool m_monitoringTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
