﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm-contacts/SSMContacts_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSMContacts {
namespace Model {
class CreateContactChannelResult {
 public:
  AWS_SSMCONTACTS_API CreateContactChannelResult() = default;
  AWS_SSMCONTACTS_API CreateContactChannelResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSMCONTACTS_API CreateContactChannelResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the contact channel.</p>
   */
  inline const Aws::String& GetContactChannelArn() const { return m_contactChannelArn; }
  template <typename ContactChannelArnT = Aws::String>
  void SetContactChannelArn(ContactChannelArnT&& value) {
    m_contactChannelArnHasBeenSet = true;
    m_contactChannelArn = std::forward<ContactChannelArnT>(value);
  }
  template <typename ContactChannelArnT = Aws::String>
  CreateContactChannelResult& WithContactChannelArn(ContactChannelArnT&& value) {
    SetContactChannelArn(std::forward<ContactChannelArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateContactChannelResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_contactChannelArn;
  bool m_contactChannelArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSMContacts
}  // namespace Aws
