﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>A failed annotation.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/AnnotationError">AWS
 * API Reference</a></p>
 */
class AnnotationError {
 public:
  AWS_GLUE_API AnnotationError() = default;
  AWS_GLUE_API AnnotationError(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API AnnotationError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Profile ID for the failed annotation.</p>
   */
  inline const Aws::String& GetProfileId() const { return m_profileId; }
  inline bool ProfileIdHasBeenSet() const { return m_profileIdHasBeenSet; }
  template <typename ProfileIdT = Aws::String>
  void SetProfileId(ProfileIdT&& value) {
    m_profileIdHasBeenSet = true;
    m_profileId = std::forward<ProfileIdT>(value);
  }
  template <typename ProfileIdT = Aws::String>
  AnnotationError& WithProfileId(ProfileIdT&& value) {
    SetProfileId(std::forward<ProfileIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Statistic ID for the failed annotation.</p>
   */
  inline const Aws::String& GetStatisticId() const { return m_statisticId; }
  inline bool StatisticIdHasBeenSet() const { return m_statisticIdHasBeenSet; }
  template <typename StatisticIdT = Aws::String>
  void SetStatisticId(StatisticIdT&& value) {
    m_statisticIdHasBeenSet = true;
    m_statisticId = std::forward<StatisticIdT>(value);
  }
  template <typename StatisticIdT = Aws::String>
  AnnotationError& WithStatisticId(StatisticIdT&& value) {
    SetStatisticId(std::forward<StatisticIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason why the annotation failed.</p>
   */
  inline const Aws::String& GetFailureReason() const { return m_failureReason; }
  inline bool FailureReasonHasBeenSet() const { return m_failureReasonHasBeenSet; }
  template <typename FailureReasonT = Aws::String>
  void SetFailureReason(FailureReasonT&& value) {
    m_failureReasonHasBeenSet = true;
    m_failureReason = std::forward<FailureReasonT>(value);
  }
  template <typename FailureReasonT = Aws::String>
  AnnotationError& WithFailureReason(FailureReasonT&& value) {
    SetFailureReason(std::forward<FailureReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_profileId;
  bool m_profileIdHasBeenSet = false;

  Aws::String m_statisticId;
  bool m_statisticIdHasBeenSet = false;

  Aws::String m_failureReason;
  bool m_failureReasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
