﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>Provides information about the status and settings of the email channel for
 * an application.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EmailChannelResponse">AWS
 * API Reference</a></p>
 */
class EmailChannelResponse {
 public:
  AWS_PINPOINT_API EmailChannelResponse() = default;
  AWS_PINPOINT_API EmailChannelResponse(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API EmailChannelResponse& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier for the application that the email channel applies
   * to.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  EmailChannelResponse& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <a
   * href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon
   * SES configuration set</a> that's applied to messages that are sent through the
   * channel.</p>
   */
  inline const Aws::String& GetConfigurationSet() const { return m_configurationSet; }
  inline bool ConfigurationSetHasBeenSet() const { return m_configurationSetHasBeenSet; }
  template <typename ConfigurationSetT = Aws::String>
  void SetConfigurationSet(ConfigurationSetT&& value) {
    m_configurationSetHasBeenSet = true;
    m_configurationSet = std::forward<ConfigurationSetT>(value);
  }
  template <typename ConfigurationSetT = Aws::String>
  EmailChannelResponse& WithConfigurationSet(ConfigurationSetT&& value) {
    SetConfigurationSet(std::forward<ConfigurationSetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time, in ISO 8601 format, when the email channel was
   * enabled.</p>
   */
  inline const Aws::String& GetCreationDate() const { return m_creationDate; }
  inline bool CreationDateHasBeenSet() const { return m_creationDateHasBeenSet; }
  template <typename CreationDateT = Aws::String>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::String>
  EmailChannelResponse& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the email channel is enabled for the application.</p>
   */
  inline bool GetEnabled() const { return m_enabled; }
  inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }
  inline void SetEnabled(bool value) {
    m_enabledHasBeenSet = true;
    m_enabled = value;
  }
  inline EmailChannelResponse& WithEnabled(bool value) {
    SetEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The verified email address that email is sent from when you send email
   * through the channel.</p>
   */
  inline const Aws::String& GetFromAddress() const { return m_fromAddress; }
  inline bool FromAddressHasBeenSet() const { return m_fromAddressHasBeenSet; }
  template <typename FromAddressT = Aws::String>
  void SetFromAddress(FromAddressT&& value) {
    m_fromAddressHasBeenSet = true;
    m_fromAddress = std::forward<FromAddressT>(value);
  }
  template <typename FromAddressT = Aws::String>
  EmailChannelResponse& WithFromAddress(FromAddressT&& value) {
    SetFromAddress(std::forward<FromAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>(Not used) This property is retained only for backward compatibility.</p>
   */
  inline bool GetHasCredential() const { return m_hasCredential; }
  inline bool HasCredentialHasBeenSet() const { return m_hasCredentialHasBeenSet; }
  inline void SetHasCredential(bool value) {
    m_hasCredentialHasBeenSet = true;
    m_hasCredential = value;
  }
  inline EmailChannelResponse& WithHasCredential(bool value) {
    SetHasCredential(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>(Deprecated) An identifier for the email channel. This property is retained
   * only for backward compatibility.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  EmailChannelResponse& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
   * Email Service (Amazon SES), that's used when you send email through the
   * channel.</p>
   */
  inline const Aws::String& GetIdentity() const { return m_identity; }
  inline bool IdentityHasBeenSet() const { return m_identityHasBeenSet; }
  template <typename IdentityT = Aws::String>
  void SetIdentity(IdentityT&& value) {
    m_identityHasBeenSet = true;
    m_identity = std::forward<IdentityT>(value);
  }
  template <typename IdentityT = Aws::String>
  EmailChannelResponse& WithIdentity(IdentityT&& value) {
    SetIdentity(std::forward<IdentityT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the email channel is archived.</p>
   */
  inline bool GetIsArchived() const { return m_isArchived; }
  inline bool IsArchivedHasBeenSet() const { return m_isArchivedHasBeenSet; }
  inline void SetIsArchived(bool value) {
    m_isArchivedHasBeenSet = true;
    m_isArchived = value;
  }
  inline EmailChannelResponse& WithIsArchived(bool value) {
    SetIsArchived(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user who last modified the email channel.</p>
   */
  inline const Aws::String& GetLastModifiedBy() const { return m_lastModifiedBy; }
  inline bool LastModifiedByHasBeenSet() const { return m_lastModifiedByHasBeenSet; }
  template <typename LastModifiedByT = Aws::String>
  void SetLastModifiedBy(LastModifiedByT&& value) {
    m_lastModifiedByHasBeenSet = true;
    m_lastModifiedBy = std::forward<LastModifiedByT>(value);
  }
  template <typename LastModifiedByT = Aws::String>
  EmailChannelResponse& WithLastModifiedBy(LastModifiedByT&& value) {
    SetLastModifiedBy(std::forward<LastModifiedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time, in ISO 8601 format, when the email channel was last
   * modified.</p>
   */
  inline const Aws::String& GetLastModifiedDate() const { return m_lastModifiedDate; }
  inline bool LastModifiedDateHasBeenSet() const { return m_lastModifiedDateHasBeenSet; }
  template <typename LastModifiedDateT = Aws::String>
  void SetLastModifiedDate(LastModifiedDateT&& value) {
    m_lastModifiedDateHasBeenSet = true;
    m_lastModifiedDate = std::forward<LastModifiedDateT>(value);
  }
  template <typename LastModifiedDateT = Aws::String>
  EmailChannelResponse& WithLastModifiedDate(LastModifiedDateT&& value) {
    SetLastModifiedDate(std::forward<LastModifiedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of emails that can be sent through the channel each
   * second.</p>
   */
  inline int GetMessagesPerSecond() const { return m_messagesPerSecond; }
  inline bool MessagesPerSecondHasBeenSet() const { return m_messagesPerSecondHasBeenSet; }
  inline void SetMessagesPerSecond(int value) {
    m_messagesPerSecondHasBeenSet = true;
    m_messagesPerSecond = value;
  }
  inline EmailChannelResponse& WithMessagesPerSecond(int value) {
    SetMessagesPerSecond(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of messaging or notification platform for the channel. For the email
   * channel, this value is EMAIL.</p>
   */
  inline const Aws::String& GetPlatform() const { return m_platform; }
  inline bool PlatformHasBeenSet() const { return m_platformHasBeenSet; }
  template <typename PlatformT = Aws::String>
  void SetPlatform(PlatformT&& value) {
    m_platformHasBeenSet = true;
    m_platform = std::forward<PlatformT>(value);
  }
  template <typename PlatformT = Aws::String>
  EmailChannelResponse& WithPlatform(PlatformT&& value) {
    SetPlatform(std::forward<PlatformT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon
   * Pinpoint uses to submit email-related event data for the channel.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  EmailChannelResponse& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of an IAM role for Amazon Pinpoint to use to send email from your
   * campaigns or journeys through Amazon SES.</p>
   */
  inline const Aws::String& GetOrchestrationSendingRoleArn() const { return m_orchestrationSendingRoleArn; }
  inline bool OrchestrationSendingRoleArnHasBeenSet() const { return m_orchestrationSendingRoleArnHasBeenSet; }
  template <typename OrchestrationSendingRoleArnT = Aws::String>
  void SetOrchestrationSendingRoleArn(OrchestrationSendingRoleArnT&& value) {
    m_orchestrationSendingRoleArnHasBeenSet = true;
    m_orchestrationSendingRoleArn = std::forward<OrchestrationSendingRoleArnT>(value);
  }
  template <typename OrchestrationSendingRoleArnT = Aws::String>
  EmailChannelResponse& WithOrchestrationSendingRoleArn(OrchestrationSendingRoleArnT&& value) {
    SetOrchestrationSendingRoleArn(std::forward<OrchestrationSendingRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current version of the email channel.</p>
   */
  inline int GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  inline void SetVersion(int value) {
    m_versionHasBeenSet = true;
    m_version = value;
  }
  inline EmailChannelResponse& WithVersion(int value) {
    SetVersion(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;
  bool m_applicationIdHasBeenSet = false;

  Aws::String m_configurationSet;
  bool m_configurationSetHasBeenSet = false;

  Aws::String m_creationDate;
  bool m_creationDateHasBeenSet = false;

  bool m_enabled{false};
  bool m_enabledHasBeenSet = false;

  Aws::String m_fromAddress;
  bool m_fromAddressHasBeenSet = false;

  bool m_hasCredential{false};
  bool m_hasCredentialHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_identity;
  bool m_identityHasBeenSet = false;

  bool m_isArchived{false};
  bool m_isArchivedHasBeenSet = false;

  Aws::String m_lastModifiedBy;
  bool m_lastModifiedByHasBeenSet = false;

  Aws::String m_lastModifiedDate;
  bool m_lastModifiedDateHasBeenSet = false;

  int m_messagesPerSecond{0};
  bool m_messagesPerSecondHasBeenSet = false;

  Aws::String m_platform;
  bool m_platformHasBeenSet = false;

  Aws::String m_roleArn;
  bool m_roleArnHasBeenSet = false;

  Aws::String m_orchestrationSendingRoleArn;
  bool m_orchestrationSendingRoleArnHasBeenSet = false;

  int m_version{0};
  bool m_versionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
