﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/proton/Proton_EXPORTS.h>
#include <aws/proton/model/TemplateVersionStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Proton {
namespace Model {

/**
 * <p>The environment template version data.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/EnvironmentTemplateVersion">AWS
 * API Reference</a></p>
 */
class EnvironmentTemplateVersion {
 public:
  AWS_PROTON_API EnvironmentTemplateVersion() = default;
  AWS_PROTON_API EnvironmentTemplateVersion(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API EnvironmentTemplateVersion& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  EnvironmentTemplateVersion& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the version of an environment template was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  EnvironmentTemplateVersion& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the minor version of an environment template.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  EnvironmentTemplateVersion& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the version of an environment template was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedAt() const { return m_lastModifiedAt; }
  inline bool LastModifiedAtHasBeenSet() const { return m_lastModifiedAtHasBeenSet; }
  template <typename LastModifiedAtT = Aws::Utils::DateTime>
  void SetLastModifiedAt(LastModifiedAtT&& value) {
    m_lastModifiedAtHasBeenSet = true;
    m_lastModifiedAt = std::forward<LastModifiedAtT>(value);
  }
  template <typename LastModifiedAtT = Aws::Utils::DateTime>
  EnvironmentTemplateVersion& WithLastModifiedAt(LastModifiedAtT&& value) {
    SetLastModifiedAt(std::forward<LastModifiedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latest major version that's associated with the version of an environment
   * template.</p>
   */
  inline const Aws::String& GetMajorVersion() const { return m_majorVersion; }
  inline bool MajorVersionHasBeenSet() const { return m_majorVersionHasBeenSet; }
  template <typename MajorVersionT = Aws::String>
  void SetMajorVersion(MajorVersionT&& value) {
    m_majorVersionHasBeenSet = true;
    m_majorVersion = std::forward<MajorVersionT>(value);
  }
  template <typename MajorVersionT = Aws::String>
  EnvironmentTemplateVersion& WithMajorVersion(MajorVersionT&& value) {
    SetMajorVersion(std::forward<MajorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minor version of an environment template.</p>
   */
  inline const Aws::String& GetMinorVersion() const { return m_minorVersion; }
  inline bool MinorVersionHasBeenSet() const { return m_minorVersionHasBeenSet; }
  template <typename MinorVersionT = Aws::String>
  void SetMinorVersion(MinorVersionT&& value) {
    m_minorVersionHasBeenSet = true;
    m_minorVersion = std::forward<MinorVersionT>(value);
  }
  template <typename MinorVersionT = Aws::String>
  EnvironmentTemplateVersion& WithMinorVersion(MinorVersionT&& value) {
    SetMinorVersion(std::forward<MinorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The recommended minor version of the environment template.</p>
   */
  inline const Aws::String& GetRecommendedMinorVersion() const { return m_recommendedMinorVersion; }
  inline bool RecommendedMinorVersionHasBeenSet() const { return m_recommendedMinorVersionHasBeenSet; }
  template <typename RecommendedMinorVersionT = Aws::String>
  void SetRecommendedMinorVersion(RecommendedMinorVersionT&& value) {
    m_recommendedMinorVersionHasBeenSet = true;
    m_recommendedMinorVersion = std::forward<RecommendedMinorVersionT>(value);
  }
  template <typename RecommendedMinorVersionT = Aws::String>
  EnvironmentTemplateVersion& WithRecommendedMinorVersion(RecommendedMinorVersionT&& value) {
    SetRecommendedMinorVersion(std::forward<RecommendedMinorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The schema of the version of an environment template.</p>
   */
  inline const Aws::String& GetSchema() const { return m_schema; }
  inline bool SchemaHasBeenSet() const { return m_schemaHasBeenSet; }
  template <typename SchemaT = Aws::String>
  void SetSchema(SchemaT&& value) {
    m_schemaHasBeenSet = true;
    m_schema = std::forward<SchemaT>(value);
  }
  template <typename SchemaT = Aws::String>
  EnvironmentTemplateVersion& WithSchema(SchemaT&& value) {
    SetSchema(std::forward<SchemaT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the version of an environment template.</p>
   */
  inline TemplateVersionStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(TemplateVersionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline EnvironmentTemplateVersion& WithStatus(TemplateVersionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status message of the version of an environment template.</p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  inline bool StatusMessageHasBeenSet() const { return m_statusMessageHasBeenSet; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  EnvironmentTemplateVersion& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the version of an environment template.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  EnvironmentTemplateVersion& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::Utils::DateTime m_createdAt{};
  bool m_createdAtHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedAt{};
  bool m_lastModifiedAtHasBeenSet = false;

  Aws::String m_majorVersion;
  bool m_majorVersionHasBeenSet = false;

  Aws::String m_minorVersion;
  bool m_minorVersionHasBeenSet = false;

  Aws::String m_recommendedMinorVersion;
  bool m_recommendedMinorVersionHasBeenSet = false;

  Aws::String m_schema;
  bool m_schemaHasBeenSet = false;

  TemplateVersionStatus m_status{TemplateVersionStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_statusMessage;
  bool m_statusMessageHasBeenSet = false;

  Aws::String m_templateName;
  bool m_templateNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Proton
}  // namespace Aws
