﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMakerRequest.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SageMaker {
namespace Model {

/**
 */
class StartEdgeDeploymentStageRequest : public SageMakerRequest {
 public:
  AWS_SAGEMAKER_API StartEdgeDeploymentStageRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "StartEdgeDeploymentStage"; }

  AWS_SAGEMAKER_API Aws::String SerializePayload() const override;

  AWS_SAGEMAKER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the edge deployment plan to start.</p>
   */
  inline const Aws::String& GetEdgeDeploymentPlanName() const { return m_edgeDeploymentPlanName; }
  inline bool EdgeDeploymentPlanNameHasBeenSet() const { return m_edgeDeploymentPlanNameHasBeenSet; }
  template <typename EdgeDeploymentPlanNameT = Aws::String>
  void SetEdgeDeploymentPlanName(EdgeDeploymentPlanNameT&& value) {
    m_edgeDeploymentPlanNameHasBeenSet = true;
    m_edgeDeploymentPlanName = std::forward<EdgeDeploymentPlanNameT>(value);
  }
  template <typename EdgeDeploymentPlanNameT = Aws::String>
  StartEdgeDeploymentStageRequest& WithEdgeDeploymentPlanName(EdgeDeploymentPlanNameT&& value) {
    SetEdgeDeploymentPlanName(std::forward<EdgeDeploymentPlanNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the stage to start.</p>
   */
  inline const Aws::String& GetStageName() const { return m_stageName; }
  inline bool StageNameHasBeenSet() const { return m_stageNameHasBeenSet; }
  template <typename StageNameT = Aws::String>
  void SetStageName(StageNameT&& value) {
    m_stageNameHasBeenSet = true;
    m_stageName = std::forward<StageNameT>(value);
  }
  template <typename StageNameT = Aws::String>
  StartEdgeDeploymentStageRequest& WithStageName(StageNameT&& value) {
    SetStageName(std::forward<StageNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_edgeDeploymentPlanName;
  bool m_edgeDeploymentPlanNameHasBeenSet = false;

  Aws::String m_stageName;
  bool m_stageNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
