﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Information about an Elastic IP address.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEc2EipDetails">AWS
 * API Reference</a></p>
 */
class AwsEc2EipDetails {
 public:
  AWS_SECURITYHUB_API AwsEc2EipDetails() = default;
  AWS_SECURITYHUB_API AwsEc2EipDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsEc2EipDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the EC2 instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  AwsEc2EipDetails& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A public IP address that is associated with the EC2 instance.</p>
   */
  inline const Aws::String& GetPublicIp() const { return m_publicIp; }
  inline bool PublicIpHasBeenSet() const { return m_publicIpHasBeenSet; }
  template <typename PublicIpT = Aws::String>
  void SetPublicIp(PublicIpT&& value) {
    m_publicIpHasBeenSet = true;
    m_publicIp = std::forward<PublicIpT>(value);
  }
  template <typename PublicIpT = Aws::String>
  AwsEc2EipDetails& WithPublicIp(PublicIpT&& value) {
    SetPublicIp(std::forward<PublicIpT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier that Amazon Web Services assigns to represent the allocation
   * of the Elastic IP address for use with Amazon VPC.</p>
   */
  inline const Aws::String& GetAllocationId() const { return m_allocationId; }
  inline bool AllocationIdHasBeenSet() const { return m_allocationIdHasBeenSet; }
  template <typename AllocationIdT = Aws::String>
  void SetAllocationId(AllocationIdT&& value) {
    m_allocationIdHasBeenSet = true;
    m_allocationId = std::forward<AllocationIdT>(value);
  }
  template <typename AllocationIdT = Aws::String>
  AwsEc2EipDetails& WithAllocationId(AllocationIdT&& value) {
    SetAllocationId(std::forward<AllocationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier that represents the association of the Elastic IP address with
   * an EC2 instance.</p>
   */
  inline const Aws::String& GetAssociationId() const { return m_associationId; }
  inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
  template <typename AssociationIdT = Aws::String>
  void SetAssociationId(AssociationIdT&& value) {
    m_associationIdHasBeenSet = true;
    m_associationId = std::forward<AssociationIdT>(value);
  }
  template <typename AssociationIdT = Aws::String>
  AwsEc2EipDetails& WithAssociationId(AssociationIdT&& value) {
    SetAssociationId(std::forward<AssociationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The domain in which to allocate the address.</p> <p>If the address is for use
   * with EC2 instances in a VPC, then <code>Domain</code> is <code>vpc</code>.
   * Otherwise, <code>Domain</code> is <code>standard</code>. </p>
   */
  inline const Aws::String& GetDomain() const { return m_domain; }
  inline bool DomainHasBeenSet() const { return m_domainHasBeenSet; }
  template <typename DomainT = Aws::String>
  void SetDomain(DomainT&& value) {
    m_domainHasBeenSet = true;
    m_domain = std::forward<DomainT>(value);
  }
  template <typename DomainT = Aws::String>
  AwsEc2EipDetails& WithDomain(DomainT&& value) {
    SetDomain(std::forward<DomainT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of an IP address pool. This parameter allows Amazon EC2 to
   * select an IP address from the address pool.</p>
   */
  inline const Aws::String& GetPublicIpv4Pool() const { return m_publicIpv4Pool; }
  inline bool PublicIpv4PoolHasBeenSet() const { return m_publicIpv4PoolHasBeenSet; }
  template <typename PublicIpv4PoolT = Aws::String>
  void SetPublicIpv4Pool(PublicIpv4PoolT&& value) {
    m_publicIpv4PoolHasBeenSet = true;
    m_publicIpv4Pool = std::forward<PublicIpv4PoolT>(value);
  }
  template <typename PublicIpv4PoolT = Aws::String>
  AwsEc2EipDetails& WithPublicIpv4Pool(PublicIpv4PoolT&& value) {
    SetPublicIpv4Pool(std::forward<PublicIpv4PoolT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the location from which the Elastic IP address is advertised.</p>
   */
  inline const Aws::String& GetNetworkBorderGroup() const { return m_networkBorderGroup; }
  inline bool NetworkBorderGroupHasBeenSet() const { return m_networkBorderGroupHasBeenSet; }
  template <typename NetworkBorderGroupT = Aws::String>
  void SetNetworkBorderGroup(NetworkBorderGroupT&& value) {
    m_networkBorderGroupHasBeenSet = true;
    m_networkBorderGroup = std::forward<NetworkBorderGroupT>(value);
  }
  template <typename NetworkBorderGroupT = Aws::String>
  AwsEc2EipDetails& WithNetworkBorderGroup(NetworkBorderGroupT&& value) {
    SetNetworkBorderGroup(std::forward<NetworkBorderGroupT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the network interface.</p>
   */
  inline const Aws::String& GetNetworkInterfaceId() const { return m_networkInterfaceId; }
  inline bool NetworkInterfaceIdHasBeenSet() const { return m_networkInterfaceIdHasBeenSet; }
  template <typename NetworkInterfaceIdT = Aws::String>
  void SetNetworkInterfaceId(NetworkInterfaceIdT&& value) {
    m_networkInterfaceIdHasBeenSet = true;
    m_networkInterfaceId = std::forward<NetworkInterfaceIdT>(value);
  }
  template <typename NetworkInterfaceIdT = Aws::String>
  AwsEc2EipDetails& WithNetworkInterfaceId(NetworkInterfaceIdT&& value) {
    SetNetworkInterfaceId(std::forward<NetworkInterfaceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services account ID of the owner of the network interface.</p>
   */
  inline const Aws::String& GetNetworkInterfaceOwnerId() const { return m_networkInterfaceOwnerId; }
  inline bool NetworkInterfaceOwnerIdHasBeenSet() const { return m_networkInterfaceOwnerIdHasBeenSet; }
  template <typename NetworkInterfaceOwnerIdT = Aws::String>
  void SetNetworkInterfaceOwnerId(NetworkInterfaceOwnerIdT&& value) {
    m_networkInterfaceOwnerIdHasBeenSet = true;
    m_networkInterfaceOwnerId = std::forward<NetworkInterfaceOwnerIdT>(value);
  }
  template <typename NetworkInterfaceOwnerIdT = Aws::String>
  AwsEc2EipDetails& WithNetworkInterfaceOwnerId(NetworkInterfaceOwnerIdT&& value) {
    SetNetworkInterfaceOwnerId(std::forward<NetworkInterfaceOwnerIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The private IP address that is associated with the Elastic IP address.</p>
   */
  inline const Aws::String& GetPrivateIpAddress() const { return m_privateIpAddress; }
  inline bool PrivateIpAddressHasBeenSet() const { return m_privateIpAddressHasBeenSet; }
  template <typename PrivateIpAddressT = Aws::String>
  void SetPrivateIpAddress(PrivateIpAddressT&& value) {
    m_privateIpAddressHasBeenSet = true;
    m_privateIpAddress = std::forward<PrivateIpAddressT>(value);
  }
  template <typename PrivateIpAddressT = Aws::String>
  AwsEc2EipDetails& WithPrivateIpAddress(PrivateIpAddressT&& value) {
    SetPrivateIpAddress(std::forward<PrivateIpAddressT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;
  bool m_instanceIdHasBeenSet = false;

  Aws::String m_publicIp;
  bool m_publicIpHasBeenSet = false;

  Aws::String m_allocationId;
  bool m_allocationIdHasBeenSet = false;

  Aws::String m_associationId;
  bool m_associationIdHasBeenSet = false;

  Aws::String m_domain;
  bool m_domainHasBeenSet = false;

  Aws::String m_publicIpv4Pool;
  bool m_publicIpv4PoolHasBeenSet = false;

  Aws::String m_networkBorderGroup;
  bool m_networkBorderGroupHasBeenSet = false;

  Aws::String m_networkInterfaceId;
  bool m_networkInterfaceIdHasBeenSet = false;

  Aws::String m_networkInterfaceOwnerId;
  bool m_networkInterfaceOwnerIdHasBeenSet = false;

  Aws::String m_privateIpAddress;
  bool m_privateIpAddressHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
