﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/AgentStatus.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {
class SearchAgentStatusesResult {
 public:
  AWS_CONNECT_API SearchAgentStatusesResult() = default;
  AWS_CONNECT_API SearchAgentStatusesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECT_API SearchAgentStatusesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The search criteria to be used to return agent statuses.</p>
   */
  inline const Aws::Vector<AgentStatus>& GetAgentStatuses() const { return m_agentStatuses; }
  template <typename AgentStatusesT = Aws::Vector<AgentStatus>>
  void SetAgentStatuses(AgentStatusesT&& value) {
    m_agentStatusesHasBeenSet = true;
    m_agentStatuses = std::forward<AgentStatusesT>(value);
  }
  template <typename AgentStatusesT = Aws::Vector<AgentStatus>>
  SearchAgentStatusesResult& WithAgentStatuses(AgentStatusesT&& value) {
    SetAgentStatuses(std::forward<AgentStatusesT>(value));
    return *this;
  }
  template <typename AgentStatusesT = AgentStatus>
  SearchAgentStatusesResult& AddAgentStatuses(AgentStatusesT&& value) {
    m_agentStatusesHasBeenSet = true;
    m_agentStatuses.emplace_back(std::forward<AgentStatusesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If there are additional results, this is the token for the next set of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  SearchAgentStatusesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of agent statuses which matched your search query.</p>
   */
  inline long long GetApproximateTotalCount() const { return m_approximateTotalCount; }
  inline void SetApproximateTotalCount(long long value) {
    m_approximateTotalCountHasBeenSet = true;
    m_approximateTotalCount = value;
  }
  inline SearchAgentStatusesResult& WithApproximateTotalCount(long long value) {
    SetApproximateTotalCount(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SearchAgentStatusesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AgentStatus> m_agentStatuses;
  bool m_agentStatusesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  long long m_approximateTotalCount{0};
  bool m_approximateTotalCountHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
