﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/TaskParameterValue.h>
#include <aws/deadline/model/TaskRunStatus.h>
#include <aws/deadline/model/TaskTargetRunStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {

/**
 * <p>The details of a task.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TaskSummary">AWS
 * API Reference</a></p>
 */
class TaskSummary {
 public:
  AWS_DEADLINE_API TaskSummary() = default;
  AWS_DEADLINE_API TaskSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API TaskSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The task ID.</p>
   */
  inline const Aws::String& GetTaskId() const { return m_taskId; }
  inline bool TaskIdHasBeenSet() const { return m_taskIdHasBeenSet; }
  template <typename TaskIdT = Aws::String>
  void SetTaskId(TaskIdT&& value) {
    m_taskIdHasBeenSet = true;
    m_taskId = std::forward<TaskIdT>(value);
  }
  template <typename TaskIdT = Aws::String>
  TaskSummary& WithTaskId(TaskIdT&& value) {
    SetTaskId(std::forward<TaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time the resource was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  TaskSummary& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user or system that created this resource.</p>
   */
  inline const Aws::String& GetCreatedBy() const { return m_createdBy; }
  inline bool CreatedByHasBeenSet() const { return m_createdByHasBeenSet; }
  template <typename CreatedByT = Aws::String>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = Aws::String>
  TaskSummary& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The run status of the task.</p>
   */
  inline TaskRunStatus GetRunStatus() const { return m_runStatus; }
  inline bool RunStatusHasBeenSet() const { return m_runStatusHasBeenSet; }
  inline void SetRunStatus(TaskRunStatus value) {
    m_runStatusHasBeenSet = true;
    m_runStatus = value;
  }
  inline TaskSummary& WithRunStatus(TaskRunStatus value) {
    SetRunStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The run status on which the started.</p>
   */
  inline TaskTargetRunStatus GetTargetRunStatus() const { return m_targetRunStatus; }
  inline bool TargetRunStatusHasBeenSet() const { return m_targetRunStatusHasBeenSet; }
  inline void SetTargetRunStatus(TaskTargetRunStatus value) {
    m_targetRunStatusHasBeenSet = true;
    m_targetRunStatus = value;
  }
  inline TaskSummary& WithTargetRunStatus(TaskTargetRunStatus value) {
    SetTargetRunStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of times that the task failed and was retried.</p>
   */
  inline int GetFailureRetryCount() const { return m_failureRetryCount; }
  inline bool FailureRetryCountHasBeenSet() const { return m_failureRetryCountHasBeenSet; }
  inline void SetFailureRetryCount(int value) {
    m_failureRetryCountHasBeenSet = true;
    m_failureRetryCount = value;
  }
  inline TaskSummary& WithFailureRetryCount(int value) {
    SetFailureRetryCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The task parameters.</p>
   */
  inline const Aws::Map<Aws::String, TaskParameterValue>& GetParameters() const { return m_parameters; }
  inline bool ParametersHasBeenSet() const { return m_parametersHasBeenSet; }
  template <typename ParametersT = Aws::Map<Aws::String, TaskParameterValue>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Map<Aws::String, TaskParameterValue>>
  TaskSummary& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersKeyT = Aws::String, typename ParametersValueT = TaskParameterValue>
  TaskSummary& AddParameters(ParametersKeyT&& key, ParametersValueT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace(std::forward<ParametersKeyT>(key), std::forward<ParametersValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time the resource started running.</p>
   */
  inline const Aws::Utils::DateTime& GetStartedAt() const { return m_startedAt; }
  inline bool StartedAtHasBeenSet() const { return m_startedAtHasBeenSet; }
  template <typename StartedAtT = Aws::Utils::DateTime>
  void SetStartedAt(StartedAtT&& value) {
    m_startedAtHasBeenSet = true;
    m_startedAt = std::forward<StartedAtT>(value);
  }
  template <typename StartedAtT = Aws::Utils::DateTime>
  TaskSummary& WithStartedAt(StartedAtT&& value) {
    SetStartedAt(std::forward<StartedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time the resource ended running.</p>
   */
  inline const Aws::Utils::DateTime& GetEndedAt() const { return m_endedAt; }
  inline bool EndedAtHasBeenSet() const { return m_endedAtHasBeenSet; }
  template <typename EndedAtT = Aws::Utils::DateTime>
  void SetEndedAt(EndedAtT&& value) {
    m_endedAtHasBeenSet = true;
    m_endedAt = std::forward<EndedAtT>(value);
  }
  template <typename EndedAtT = Aws::Utils::DateTime>
  TaskSummary& WithEndedAt(EndedAtT&& value) {
    SetEndedAt(std::forward<EndedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time the resource was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  TaskSummary& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user or system that updated this resource.</p>
   */
  inline const Aws::String& GetUpdatedBy() const { return m_updatedBy; }
  inline bool UpdatedByHasBeenSet() const { return m_updatedByHasBeenSet; }
  template <typename UpdatedByT = Aws::String>
  void SetUpdatedBy(UpdatedByT&& value) {
    m_updatedByHasBeenSet = true;
    m_updatedBy = std::forward<UpdatedByT>(value);
  }
  template <typename UpdatedByT = Aws::String>
  TaskSummary& WithUpdatedBy(UpdatedByT&& value) {
    SetUpdatedBy(std::forward<UpdatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latest session action for the task.</p>
   */
  inline const Aws::String& GetLatestSessionActionId() const { return m_latestSessionActionId; }
  inline bool LatestSessionActionIdHasBeenSet() const { return m_latestSessionActionIdHasBeenSet; }
  template <typename LatestSessionActionIdT = Aws::String>
  void SetLatestSessionActionId(LatestSessionActionIdT&& value) {
    m_latestSessionActionIdHasBeenSet = true;
    m_latestSessionActionId = std::forward<LatestSessionActionIdT>(value);
  }
  template <typename LatestSessionActionIdT = Aws::String>
  TaskSummary& WithLatestSessionActionId(LatestSessionActionIdT&& value) {
    SetLatestSessionActionId(std::forward<LatestSessionActionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_taskId;
  bool m_taskIdHasBeenSet = false;

  Aws::Utils::DateTime m_createdAt{};
  bool m_createdAtHasBeenSet = false;

  Aws::String m_createdBy;
  bool m_createdByHasBeenSet = false;

  TaskRunStatus m_runStatus{TaskRunStatus::NOT_SET};
  bool m_runStatusHasBeenSet = false;

  TaskTargetRunStatus m_targetRunStatus{TaskTargetRunStatus::NOT_SET};
  bool m_targetRunStatusHasBeenSet = false;

  int m_failureRetryCount{0};
  bool m_failureRetryCountHasBeenSet = false;

  Aws::Map<Aws::String, TaskParameterValue> m_parameters;
  bool m_parametersHasBeenSet = false;

  Aws::Utils::DateTime m_startedAt{};
  bool m_startedAtHasBeenSet = false;

  Aws::Utils::DateTime m_endedAt{};
  bool m_endedAtHasBeenSet = false;

  Aws::Utils::DateTime m_updatedAt{};
  bool m_updatedAtHasBeenSet = false;

  Aws::String m_updatedBy;
  bool m_updatedByHasBeenSet = false;

  Aws::String m_latestSessionActionId;
  bool m_latestSessionActionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
