﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/ExperimentError.h>
#include <aws/fis/model/ExperimentStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {

/**
 * <p>Describes the state of an experiment.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ExperimentState">AWS
 * API Reference</a></p>
 */
class ExperimentState {
 public:
  AWS_FIS_API ExperimentState() = default;
  AWS_FIS_API ExperimentState(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API ExperimentState& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The state of the experiment.</p>
   */
  inline ExperimentStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ExperimentStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ExperimentState& WithStatus(ExperimentStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason for the state.</p>
   */
  inline const Aws::String& GetReason() const { return m_reason; }
  inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
  template <typename ReasonT = Aws::String>
  void SetReason(ReasonT&& value) {
    m_reasonHasBeenSet = true;
    m_reason = std::forward<ReasonT>(value);
  }
  template <typename ReasonT = Aws::String>
  ExperimentState& WithReason(ReasonT&& value) {
    SetReason(std::forward<ReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error information of the experiment when the action has
   * <code>failed</code>.</p>
   */
  inline const ExperimentError& GetError() const { return m_error; }
  inline bool ErrorHasBeenSet() const { return m_errorHasBeenSet; }
  template <typename ErrorT = ExperimentError>
  void SetError(ErrorT&& value) {
    m_errorHasBeenSet = true;
    m_error = std::forward<ErrorT>(value);
  }
  template <typename ErrorT = ExperimentError>
  ExperimentState& WithError(ErrorT&& value) {
    SetError(std::forward<ErrorT>(value));
    return *this;
  }
  ///@}
 private:
  ExperimentStatus m_status{ExperimentStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_reason;
  bool m_reasonHasBeenSet = false;

  ExperimentError m_error;
  bool m_errorHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
