﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/IncrementalScanDetails.h>
#include <aws/guardduty/model/TriggerType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains finding configuration details about the malware scan.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionFindingsScanConfiguration">AWS
 * API Reference</a></p>
 */
class MalwareProtectionFindingsScanConfiguration {
 public:
  AWS_GUARDDUTY_API MalwareProtectionFindingsScanConfiguration() = default;
  AWS_GUARDDUTY_API MalwareProtectionFindingsScanConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API MalwareProtectionFindingsScanConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The event that triggered the malware scan.</p>
   */
  inline TriggerType GetTriggerType() const { return m_triggerType; }
  inline bool TriggerTypeHasBeenSet() const { return m_triggerTypeHasBeenSet; }
  inline void SetTriggerType(TriggerType value) {
    m_triggerTypeHasBeenSet = true;
    m_triggerType = value;
  }
  inline MalwareProtectionFindingsScanConfiguration& WithTriggerType(TriggerType value) {
    SetTriggerType(value);
    return *this;
  }
  ///@}

  ///@{

  inline const IncrementalScanDetails& GetIncrementalScanDetails() const { return m_incrementalScanDetails; }
  inline bool IncrementalScanDetailsHasBeenSet() const { return m_incrementalScanDetailsHasBeenSet; }
  template <typename IncrementalScanDetailsT = IncrementalScanDetails>
  void SetIncrementalScanDetails(IncrementalScanDetailsT&& value) {
    m_incrementalScanDetailsHasBeenSet = true;
    m_incrementalScanDetails = std::forward<IncrementalScanDetailsT>(value);
  }
  template <typename IncrementalScanDetailsT = IncrementalScanDetails>
  MalwareProtectionFindingsScanConfiguration& WithIncrementalScanDetails(IncrementalScanDetailsT&& value) {
    SetIncrementalScanDetails(std::forward<IncrementalScanDetailsT>(value));
    return *this;
  }
  ///@}
 private:
  TriggerType m_triggerType{TriggerType::NOT_SET};
  bool m_triggerTypeHasBeenSet = false;

  IncrementalScanDetails m_incrementalScanDetails;
  bool m_incrementalScanDetailsHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
