﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {
class CreateCustomMetricResult {
 public:
  AWS_IOT_API CreateCustomMetricResult() = default;
  AWS_IOT_API CreateCustomMetricResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOT_API CreateCustomMetricResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The name of the custom metric to be used in the metric report. </p>
   */
  inline const Aws::String& GetMetricName() const { return m_metricName; }
  template <typename MetricNameT = Aws::String>
  void SetMetricName(MetricNameT&& value) {
    m_metricNameHasBeenSet = true;
    m_metricName = std::forward<MetricNameT>(value);
  }
  template <typename MetricNameT = Aws::String>
  CreateCustomMetricResult& WithMetricName(MetricNameT&& value) {
    SetMetricName(std::forward<MetricNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Number (ARN) of the custom metric. For example,
   * <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i>
   * </code> </p>
   */
  inline const Aws::String& GetMetricArn() const { return m_metricArn; }
  template <typename MetricArnT = Aws::String>
  void SetMetricArn(MetricArnT&& value) {
    m_metricArnHasBeenSet = true;
    m_metricArn = std::forward<MetricArnT>(value);
  }
  template <typename MetricArnT = Aws::String>
  CreateCustomMetricResult& WithMetricArn(MetricArnT&& value) {
    SetMetricArn(std::forward<MetricArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateCustomMetricResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metricName;
  bool m_metricNameHasBeenSet = false;

  Aws::String m_metricArn;
  bool m_metricArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
