﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kafkaconnect/KafkaConnect_EXPORTS.h>
#include <aws/kafkaconnect/model/WorkerConfigurationState.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace KafkaConnect {
namespace Model {
class DeleteWorkerConfigurationResult {
 public:
  AWS_KAFKACONNECT_API DeleteWorkerConfigurationResult() = default;
  AWS_KAFKACONNECT_API DeleteWorkerConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_KAFKACONNECT_API DeleteWorkerConfigurationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the worker configuration that you requested
   * to delete.</p>
   */
  inline const Aws::String& GetWorkerConfigurationArn() const { return m_workerConfigurationArn; }
  template <typename WorkerConfigurationArnT = Aws::String>
  void SetWorkerConfigurationArn(WorkerConfigurationArnT&& value) {
    m_workerConfigurationArnHasBeenSet = true;
    m_workerConfigurationArn = std::forward<WorkerConfigurationArnT>(value);
  }
  template <typename WorkerConfigurationArnT = Aws::String>
  DeleteWorkerConfigurationResult& WithWorkerConfigurationArn(WorkerConfigurationArnT&& value) {
    SetWorkerConfigurationArn(std::forward<WorkerConfigurationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the worker configuration.</p>
   */
  inline WorkerConfigurationState GetWorkerConfigurationState() const { return m_workerConfigurationState; }
  inline void SetWorkerConfigurationState(WorkerConfigurationState value) {
    m_workerConfigurationStateHasBeenSet = true;
    m_workerConfigurationState = value;
  }
  inline DeleteWorkerConfigurationResult& WithWorkerConfigurationState(WorkerConfigurationState value) {
    SetWorkerConfigurationState(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteWorkerConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workerConfigurationArn;
  bool m_workerConfigurationArnHasBeenSet = false;

  WorkerConfigurationState m_workerConfigurationState{WorkerConfigurationState::NOT_SET};
  bool m_workerConfigurationStateHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace KafkaConnect
}  // namespace Aws
