﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/resiliencehub/model/GroupingRecommendation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResilienceHub {
namespace Model {
class ListResourceGroupingRecommendationsResult {
 public:
  AWS_RESILIENCEHUB_API ListResourceGroupingRecommendationsResult() = default;
  AWS_RESILIENCEHUB_API ListResourceGroupingRecommendationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESILIENCEHUB_API ListResourceGroupingRecommendationsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>List of resource grouping recommendations generated by Resilience Hub.</p>
   */
  inline const Aws::Vector<GroupingRecommendation>& GetGroupingRecommendations() const { return m_groupingRecommendations; }
  template <typename GroupingRecommendationsT = Aws::Vector<GroupingRecommendation>>
  void SetGroupingRecommendations(GroupingRecommendationsT&& value) {
    m_groupingRecommendationsHasBeenSet = true;
    m_groupingRecommendations = std::forward<GroupingRecommendationsT>(value);
  }
  template <typename GroupingRecommendationsT = Aws::Vector<GroupingRecommendation>>
  ListResourceGroupingRecommendationsResult& WithGroupingRecommendations(GroupingRecommendationsT&& value) {
    SetGroupingRecommendations(std::forward<GroupingRecommendationsT>(value));
    return *this;
  }
  template <typename GroupingRecommendationsT = GroupingRecommendation>
  ListResourceGroupingRecommendationsResult& AddGroupingRecommendations(GroupingRecommendationsT&& value) {
    m_groupingRecommendationsHasBeenSet = true;
    m_groupingRecommendations.emplace_back(std::forward<GroupingRecommendationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Null, or the token from a previous call to get the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListResourceGroupingRecommendationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListResourceGroupingRecommendationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<GroupingRecommendation> m_groupingRecommendations;
  bool m_groupingRecommendationsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResilienceHub
}  // namespace Aws
