﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/taxsettings/TaxSettings_EXPORTS.h>
#include <aws/taxsettings/model/TaxRegistrationStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace TaxSettings {
namespace Model {
class PutTaxRegistrationResult {
 public:
  AWS_TAXSETTINGS_API PutTaxRegistrationResult() = default;
  AWS_TAXSETTINGS_API PutTaxRegistrationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TAXSETTINGS_API PutTaxRegistrationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The status of your TRN stored in the system after processing. Based on the
   * validation occurring on the TRN, the status can be <code>Verified</code>,
   * <code>Pending</code> or <code>Rejected</code>. </p>
   */
  inline TaxRegistrationStatus GetStatus() const { return m_status; }
  inline void SetStatus(TaxRegistrationStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline PutTaxRegistrationResult& WithStatus(TaxRegistrationStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutTaxRegistrationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  TaxRegistrationStatus m_status{TaxRegistrationStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace TaxSettings
}  // namespace Aws
