﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>
#include <aws/customer-profiles/model/CatalogItem.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CustomerProfiles {
namespace Model {

/**
 * <p>Represents a single recommendation generated by the recommender
 * system.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/Recommendation">AWS
 * API Reference</a></p>
 */
class Recommendation {
 public:
  AWS_CUSTOMERPROFILES_API Recommendation() = default;
  AWS_CUSTOMERPROFILES_API Recommendation(Aws::Utils::Json::JsonView jsonValue);
  AWS_CUSTOMERPROFILES_API Recommendation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CUSTOMERPROFILES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The catalog item being recommended, including its complete details and
   * attributes.</p>
   */
  inline const CatalogItem& GetCatalogItem() const { return m_catalogItem; }
  inline bool CatalogItemHasBeenSet() const { return m_catalogItemHasBeenSet; }
  template <typename CatalogItemT = CatalogItem>
  void SetCatalogItem(CatalogItemT&& value) {
    m_catalogItemHasBeenSet = true;
    m_catalogItem = std::forward<CatalogItemT>(value);
  }
  template <typename CatalogItemT = CatalogItem>
  Recommendation& WithCatalogItem(CatalogItemT&& value) {
    SetCatalogItem(std::forward<CatalogItemT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Recommendation Score between 0 and 1.</p>
   */
  inline double GetScore() const { return m_score; }
  inline bool ScoreHasBeenSet() const { return m_scoreHasBeenSet; }
  inline void SetScore(double value) {
    m_scoreHasBeenSet = true;
    m_score = value;
  }
  inline Recommendation& WithScore(double value) {
    SetScore(value);
    return *this;
  }
  ///@}
 private:
  CatalogItem m_catalogItem;
  bool m_catalogItemHasBeenSet = false;

  double m_score{0.0};
  bool m_scoreHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
