﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/WorkerSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {
class ListWorkersResult {
 public:
  AWS_DEADLINE_API ListWorkersResult() = default;
  AWS_DEADLINE_API ListWorkersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DEADLINE_API ListWorkersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If Deadline Cloud returns <code>nextToken</code>, then there are more results
   * available. The value of <code>nextToken</code> is a unique pagination token for
   * each page. To retrieve the next page, call the operation again using the
   * returned token. Keep all other arguments unchanged. If no results remain, then
   * <code>nextToken</code> is set to <code>null</code>. Each pagination token
   * expires after 24 hours. If you provide a token that isn't valid, then you
   * receive an HTTP 400 <code>ValidationException</code> error.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListWorkersResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The workers on the list.</p>
   */
  inline const Aws::Vector<WorkerSummary>& GetWorkers() const { return m_workers; }
  template <typename WorkersT = Aws::Vector<WorkerSummary>>
  void SetWorkers(WorkersT&& value) {
    m_workersHasBeenSet = true;
    m_workers = std::forward<WorkersT>(value);
  }
  template <typename WorkersT = Aws::Vector<WorkerSummary>>
  ListWorkersResult& WithWorkers(WorkersT&& value) {
    SetWorkers(std::forward<WorkersT>(value));
    return *this;
  }
  template <typename WorkersT = WorkerSummary>
  ListWorkersResult& AddWorkers(WorkersT&& value) {
    m_workersHasBeenSet = true;
    m_workers.emplace_back(std::forward<WorkersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListWorkersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<WorkerSummary> m_workers;
  bool m_workersHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
