﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/events/CloudWatchEvents_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchEvents {
namespace Model {

/**
 * <p>Additional parameter included in the header. You can include up to 100
 * additional header parameters per request. An event payload cannot exceed 64
 * KB.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ConnectionHeaderParameter">AWS
 * API Reference</a></p>
 */
class ConnectionHeaderParameter {
 public:
  AWS_CLOUDWATCHEVENTS_API ConnectionHeaderParameter() = default;
  AWS_CLOUDWATCHEVENTS_API ConnectionHeaderParameter(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVENTS_API ConnectionHeaderParameter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHEVENTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The key for the parameter.</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  ConnectionHeaderParameter& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value associated with the key.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  ConnectionHeaderParameter& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specified whether the value is a secret.</p>
   */
  inline bool GetIsValueSecret() const { return m_isValueSecret; }
  inline bool IsValueSecretHasBeenSet() const { return m_isValueSecretHasBeenSet; }
  inline void SetIsValueSecret(bool value) {
    m_isValueSecretHasBeenSet = true;
    m_isValueSecret = value;
  }
  inline ConnectionHeaderParameter& WithIsValueSecret(bool value) {
    SetIsValueSecret(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;
  bool m_keyHasBeenSet = false;

  Aws::String m_value;
  bool m_valueHasBeenSet = false;

  bool m_isValueSecret{false};
  bool m_isValueSecretHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchEvents
}  // namespace Aws
