﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/GlueRequest.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Glue {
namespace Model {

/**
 */
class GetBlueprintRunRequest : public GlueRequest {
 public:
  AWS_GLUE_API GetBlueprintRunRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetBlueprintRun"; }

  AWS_GLUE_API Aws::String SerializePayload() const override;

  AWS_GLUE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the blueprint.</p>
   */
  inline const Aws::String& GetBlueprintName() const { return m_blueprintName; }
  inline bool BlueprintNameHasBeenSet() const { return m_blueprintNameHasBeenSet; }
  template <typename BlueprintNameT = Aws::String>
  void SetBlueprintName(BlueprintNameT&& value) {
    m_blueprintNameHasBeenSet = true;
    m_blueprintName = std::forward<BlueprintNameT>(value);
  }
  template <typename BlueprintNameT = Aws::String>
  GetBlueprintRunRequest& WithBlueprintName(BlueprintNameT&& value) {
    SetBlueprintName(std::forward<BlueprintNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The run ID for the blueprint run you want to retrieve.</p>
   */
  inline const Aws::String& GetRunId() const { return m_runId; }
  inline bool RunIdHasBeenSet() const { return m_runIdHasBeenSet; }
  template <typename RunIdT = Aws::String>
  void SetRunId(RunIdT&& value) {
    m_runIdHasBeenSet = true;
    m_runId = std::forward<RunIdT>(value);
  }
  template <typename RunIdT = Aws::String>
  GetBlueprintRunRequest& WithRunId(RunIdT&& value) {
    SetRunId(std::forward<RunIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_blueprintName;
  bool m_blueprintNameHasBeenSet = false;

  Aws::String m_runId;
  bool m_runIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
