﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {
class PutComponentPolicyResult {
 public:
  AWS_IMAGEBUILDER_API PutComponentPolicyResult() = default;
  AWS_IMAGEBUILDER_API PutComponentPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IMAGEBUILDER_API PutComponentPolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The request ID that uniquely identifies this request.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutComponentPolicyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the component that this policy was applied
   * to.</p>
   */
  inline const Aws::String& GetComponentArn() const { return m_componentArn; }
  template <typename ComponentArnT = Aws::String>
  void SetComponentArn(ComponentArnT&& value) {
    m_componentArnHasBeenSet = true;
    m_componentArn = std::forward<ComponentArnT>(value);
  }
  template <typename ComponentArnT = Aws::String>
  PutComponentPolicyResult& WithComponentArn(ComponentArnT&& value) {
    SetComponentArn(std::forward<ComponentArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;

  Aws::String m_componentArn;
  bool m_componentArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
