﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/textract/Textract_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Textract {
namespace Model {

/**
 * <p>A warning about an issue that occurred during asynchronous text analysis
 * (<a>StartDocumentAnalysis</a>) or asynchronous document text detection
 * (<a>StartDocumentTextDetection</a>). </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Warning">AWS
 * API Reference</a></p>
 */
class Warning {
 public:
  AWS_TEXTRACT_API Warning() = default;
  AWS_TEXTRACT_API Warning(Aws::Utils::Json::JsonView jsonValue);
  AWS_TEXTRACT_API Warning& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TEXTRACT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The error code for the warning.</p>
   */
  inline const Aws::String& GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  template <typename ErrorCodeT = Aws::String>
  void SetErrorCode(ErrorCodeT&& value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = std::forward<ErrorCodeT>(value);
  }
  template <typename ErrorCodeT = Aws::String>
  Warning& WithErrorCode(ErrorCodeT&& value) {
    SetErrorCode(std::forward<ErrorCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of the pages that the warning applies to.</p>
   */
  inline const Aws::Vector<int>& GetPages() const { return m_pages; }
  inline bool PagesHasBeenSet() const { return m_pagesHasBeenSet; }
  template <typename PagesT = Aws::Vector<int>>
  void SetPages(PagesT&& value) {
    m_pagesHasBeenSet = true;
    m_pages = std::forward<PagesT>(value);
  }
  template <typename PagesT = Aws::Vector<int>>
  Warning& WithPages(PagesT&& value) {
    SetPages(std::forward<PagesT>(value));
    return *this;
  }
  inline Warning& AddPages(int value) {
    m_pagesHasBeenSet = true;
    m_pages.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_errorCode;
  bool m_errorCodeHasBeenSet = false;

  Aws::Vector<int> m_pages;
  bool m_pagesHasBeenSet = false;
};

}  // namespace Model
}  // namespace Textract
}  // namespace Aws
