﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/timestream-write/TimestreamWrite_EXPORTS.h>
#include <aws/timestream-write/model/Table.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace TimestreamWrite {
namespace Model {
class ListTablesResult {
 public:
  AWS_TIMESTREAMWRITE_API ListTablesResult() = default;
  AWS_TIMESTREAMWRITE_API ListTablesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TIMESTREAMWRITE_API ListTablesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of tables.</p>
   */
  inline const Aws::Vector<Table>& GetTables() const { return m_tables; }
  template <typename TablesT = Aws::Vector<Table>>
  void SetTables(TablesT&& value) {
    m_tablesHasBeenSet = true;
    m_tables = std::forward<TablesT>(value);
  }
  template <typename TablesT = Aws::Vector<Table>>
  ListTablesResult& WithTables(TablesT&& value) {
    SetTables(std::forward<TablesT>(value));
    return *this;
  }
  template <typename TablesT = Table>
  ListTablesResult& AddTables(TablesT&& value) {
    m_tablesHasBeenSet = true;
    m_tables.emplace_back(std::forward<TablesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token to specify where to start paginating. This is the NextToken from a
   * previously truncated response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTablesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTablesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Table> m_tables;
  bool m_tablesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace TimestreamWrite
}  // namespace Aws
