﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>

namespace Aws {
namespace PinpointSMSVoiceV2 {
namespace Model {
enum class ValidationExceptionReason {
  NOT_SET,
  CANNOT_ADD_OPTED_OUT_NUMBER,
  CANNOT_PARSE,
  COUNTRY_CODE_MISMATCH,
  DESTINATION_COUNTRY_BLOCKED,
  FIELD_VALIDATION_FAILED,
  ATTACHMENT_TYPE_NOT_SUPPORTED,
  INTERNATIONAL_SENDING_NOT_SUPPORTED,
  INVALID_ARN,
  INVALID_FILTER_VALUES,
  INVALID_IDENTITY_FOR_DESTINATION_COUNTRY,
  INVALID_NEXT_TOKEN,
  INVALID_PARAMETER,
  INVALID_REQUEST,
  INVALID_REGISTRATION_ASSOCIATION,
  MAXIMUM_SIZE_EXCEEDED,
  MEDIA_TYPE_NOT_SUPPORTED,
  MISSING_PARAMETER,
  PARAMETERS_CANNOT_BE_USED_TOGETHER,
  PHONE_NUMBER_CANNOT_BE_OPTED_IN,
  PHONE_NUMBER_CANNOT_BE_RELEASED,
  PRICE_OVER_THRESHOLD,
  RESOURCE_NOT_ACCESSIBLE,
  REQUESTED_SPEND_LIMIT_HIGHER_THAN_SERVICE_LIMIT,
  SENDER_ID_NOT_REGISTERED,
  SENDER_ID_NOT_SUPPORTED,
  SENDER_ID_REQUIRES_REGISTRATION,
  TWO_WAY_TOPIC_NOT_PRESENT,
  TWO_WAY_NOT_ENABLED,
  TWO_WAY_NOT_SUPPORTED_IN_COUNTRY,
  TWO_WAY_NOT_SUPPORTED_IN_REGION,
  TWO_WAY_CHANNEL_NOT_PRESENT,
  UNKNOWN_REGISTRATION_FIELD,
  UNKNOWN_REGISTRATION_SECTION,
  UNKNOWN_REGISTRATION_TYPE,
  UNKNOWN_REGISTRATION_VERSION,
  UNKNOWN_OPERATION,
  REGISTRATION_FIELD_CANNOT_BE_DELETED,
  VERIFICATION_CODE_MISMATCH,
  VOICE_CAPABILITY_NOT_AVAILABLE,
  UNSPECIFIED_PARAMETER_NOT_SUPPORTED,
  OTHER
};

namespace ValidationExceptionReasonMapper {
AWS_PINPOINTSMSVOICEV2_API ValidationExceptionReason GetValidationExceptionReasonForName(const Aws::String& name);

AWS_PINPOINTSMSVOICEV2_API Aws::String GetNameForValidationExceptionReason(ValidationExceptionReason value);
}  // namespace ValidationExceptionReasonMapper
}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
