﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace EC2
{
namespace Model
{
  enum class InstanceType
  {
    NOT_SET,
    a1_medium,
    a1_large,
    a1_xlarge,
    a1_2xlarge,
    a1_4xlarge,
    a1_metal,
    c1_medium,
    c1_xlarge,
    c3_large,
    c3_xlarge,
    c3_2xlarge,
    c3_4xlarge,
    c3_8xlarge,
    c4_large,
    c4_xlarge,
    c4_2xlarge,
    c4_4xlarge,
    c4_8xlarge,
    c5_large,
    c5_xlarge,
    c5_2xlarge,
    c5_4xlarge,
    c5_9xlarge,
    c5_12xlarge,
    c5_18xlarge,
    c5_24xlarge,
    c5_metal,
    c5a_large,
    c5a_xlarge,
    c5a_2xlarge,
    c5a_4xlarge,
    c5a_8xlarge,
    c5a_12xlarge,
    c5a_16xlarge,
    c5a_24xlarge,
    c5ad_large,
    c5ad_xlarge,
    c5ad_2xlarge,
    c5ad_4xlarge,
    c5ad_8xlarge,
    c5ad_12xlarge,
    c5ad_16xlarge,
    c5ad_24xlarge,
    c5d_large,
    c5d_xlarge,
    c5d_2xlarge,
    c5d_4xlarge,
    c5d_9xlarge,
    c5d_12xlarge,
    c5d_18xlarge,
    c5d_24xlarge,
    c5d_metal,
    c5n_large,
    c5n_xlarge,
    c5n_2xlarge,
    c5n_4xlarge,
    c5n_9xlarge,
    c5n_18xlarge,
    c5n_metal,
    c6g_medium,
    c6g_large,
    c6g_xlarge,
    c6g_2xlarge,
    c6g_4xlarge,
    c6g_8xlarge,
    c6g_12xlarge,
    c6g_16xlarge,
    c6g_metal,
    c6gd_medium,
    c6gd_large,
    c6gd_xlarge,
    c6gd_2xlarge,
    c6gd_4xlarge,
    c6gd_8xlarge,
    c6gd_12xlarge,
    c6gd_16xlarge,
    c6gd_metal,
    c6gn_medium,
    c6gn_large,
    c6gn_xlarge,
    c6gn_2xlarge,
    c6gn_4xlarge,
    c6gn_8xlarge,
    c6gn_12xlarge,
    c6gn_16xlarge,
    c6i_large,
    c6i_xlarge,
    c6i_2xlarge,
    c6i_4xlarge,
    c6i_8xlarge,
    c6i_12xlarge,
    c6i_16xlarge,
    c6i_24xlarge,
    c6i_32xlarge,
    c6i_metal,
    cc1_4xlarge,
    cc2_8xlarge,
    cg1_4xlarge,
    cr1_8xlarge,
    d2_xlarge,
    d2_2xlarge,
    d2_4xlarge,
    d2_8xlarge,
    d3_xlarge,
    d3_2xlarge,
    d3_4xlarge,
    d3_8xlarge,
    d3en_xlarge,
    d3en_2xlarge,
    d3en_4xlarge,
    d3en_6xlarge,
    d3en_8xlarge,
    d3en_12xlarge,
    dl1_24xlarge,
    f1_2xlarge,
    f1_4xlarge,
    f1_16xlarge,
    g2_2xlarge,
    g2_8xlarge,
    g3_4xlarge,
    g3_8xlarge,
    g3_16xlarge,
    g3s_xlarge,
    g4ad_xlarge,
    g4ad_2xlarge,
    g4ad_4xlarge,
    g4ad_8xlarge,
    g4ad_16xlarge,
    g4dn_xlarge,
    g4dn_2xlarge,
    g4dn_4xlarge,
    g4dn_8xlarge,
    g4dn_12xlarge,
    g4dn_16xlarge,
    g4dn_metal,
    g5_xlarge,
    g5_2xlarge,
    g5_4xlarge,
    g5_8xlarge,
    g5_12xlarge,
    g5_16xlarge,
    g5_24xlarge,
    g5_48xlarge,
    g5g_xlarge,
    g5g_2xlarge,
    g5g_4xlarge,
    g5g_8xlarge,
    g5g_16xlarge,
    g5g_metal,
    hi1_4xlarge,
    hpc6a_48xlarge,
    hs1_8xlarge,
    h1_2xlarge,
    h1_4xlarge,
    h1_8xlarge,
    h1_16xlarge,
    i2_xlarge,
    i2_2xlarge,
    i2_4xlarge,
    i2_8xlarge,
    i3_large,
    i3_xlarge,
    i3_2xlarge,
    i3_4xlarge,
    i3_8xlarge,
    i3_16xlarge,
    i3_metal,
    i3en_large,
    i3en_xlarge,
    i3en_2xlarge,
    i3en_3xlarge,
    i3en_6xlarge,
    i3en_12xlarge,
    i3en_24xlarge,
    i3en_metal,
    im4gn_large,
    im4gn_xlarge,
    im4gn_2xlarge,
    im4gn_4xlarge,
    im4gn_8xlarge,
    im4gn_16xlarge,
    inf1_xlarge,
    inf1_2xlarge,
    inf1_6xlarge,
    inf1_24xlarge,
    is4gen_medium,
    is4gen_large,
    is4gen_xlarge,
    is4gen_2xlarge,
    is4gen_4xlarge,
    is4gen_8xlarge,
    m1_small,
    m1_medium,
    m1_large,
    m1_xlarge,
    m2_xlarge,
    m2_2xlarge,
    m2_4xlarge,
    m3_medium,
    m3_large,
    m3_xlarge,
    m3_2xlarge,
    m4_large,
    m4_xlarge,
    m4_2xlarge,
    m4_4xlarge,
    m4_10xlarge,
    m4_16xlarge,
    m5_large,
    m5_xlarge,
    m5_2xlarge,
    m5_4xlarge,
    m5_8xlarge,
    m5_12xlarge,
    m5_16xlarge,
    m5_24xlarge,
    m5_metal,
    m5a_large,
    m5a_xlarge,
    m5a_2xlarge,
    m5a_4xlarge,
    m5a_8xlarge,
    m5a_12xlarge,
    m5a_16xlarge,
    m5a_24xlarge,
    m5ad_large,
    m5ad_xlarge,
    m5ad_2xlarge,
    m5ad_4xlarge,
    m5ad_8xlarge,
    m5ad_12xlarge,
    m5ad_16xlarge,
    m5ad_24xlarge,
    m5d_large,
    m5d_xlarge,
    m5d_2xlarge,
    m5d_4xlarge,
    m5d_8xlarge,
    m5d_12xlarge,
    m5d_16xlarge,
    m5d_24xlarge,
    m5d_metal,
    m5dn_large,
    m5dn_xlarge,
    m5dn_2xlarge,
    m5dn_4xlarge,
    m5dn_8xlarge,
    m5dn_12xlarge,
    m5dn_16xlarge,
    m5dn_24xlarge,
    m5dn_metal,
    m5n_large,
    m5n_xlarge,
    m5n_2xlarge,
    m5n_4xlarge,
    m5n_8xlarge,
    m5n_12xlarge,
    m5n_16xlarge,
    m5n_24xlarge,
    m5n_metal,
    m5zn_large,
    m5zn_xlarge,
    m5zn_2xlarge,
    m5zn_3xlarge,
    m5zn_6xlarge,
    m5zn_12xlarge,
    m5zn_metal,
    m6a_large,
    m6a_xlarge,
    m6a_2xlarge,
    m6a_4xlarge,
    m6a_8xlarge,
    m6a_12xlarge,
    m6a_16xlarge,
    m6a_24xlarge,
    m6a_32xlarge,
    m6a_48xlarge,
    m6g_metal,
    m6g_medium,
    m6g_large,
    m6g_xlarge,
    m6g_2xlarge,
    m6g_4xlarge,
    m6g_8xlarge,
    m6g_12xlarge,
    m6g_16xlarge,
    m6gd_metal,
    m6gd_medium,
    m6gd_large,
    m6gd_xlarge,
    m6gd_2xlarge,
    m6gd_4xlarge,
    m6gd_8xlarge,
    m6gd_12xlarge,
    m6gd_16xlarge,
    m6i_large,
    m6i_xlarge,
    m6i_2xlarge,
    m6i_4xlarge,
    m6i_8xlarge,
    m6i_12xlarge,
    m6i_16xlarge,
    m6i_24xlarge,
    m6i_32xlarge,
    m6i_metal,
    mac1_metal,
    p2_xlarge,
    p2_8xlarge,
    p2_16xlarge,
    p3_2xlarge,
    p3_8xlarge,
    p3_16xlarge,
    p3dn_24xlarge,
    p4d_24xlarge,
    r3_large,
    r3_xlarge,
    r3_2xlarge,
    r3_4xlarge,
    r3_8xlarge,
    r4_large,
    r4_xlarge,
    r4_2xlarge,
    r4_4xlarge,
    r4_8xlarge,
    r4_16xlarge,
    r5_large,
    r5_xlarge,
    r5_2xlarge,
    r5_4xlarge,
    r5_8xlarge,
    r5_12xlarge,
    r5_16xlarge,
    r5_24xlarge,
    r5_metal,
    r5a_large,
    r5a_xlarge,
    r5a_2xlarge,
    r5a_4xlarge,
    r5a_8xlarge,
    r5a_12xlarge,
    r5a_16xlarge,
    r5a_24xlarge,
    r5ad_large,
    r5ad_xlarge,
    r5ad_2xlarge,
    r5ad_4xlarge,
    r5ad_8xlarge,
    r5ad_12xlarge,
    r5ad_16xlarge,
    r5ad_24xlarge,
    r5b_large,
    r5b_xlarge,
    r5b_2xlarge,
    r5b_4xlarge,
    r5b_8xlarge,
    r5b_12xlarge,
    r5b_16xlarge,
    r5b_24xlarge,
    r5b_metal,
    r5d_large,
    r5d_xlarge,
    r5d_2xlarge,
    r5d_4xlarge,
    r5d_8xlarge,
    r5d_12xlarge,
    r5d_16xlarge,
    r5d_24xlarge,
    r5d_metal,
    r5dn_large,
    r5dn_xlarge,
    r5dn_2xlarge,
    r5dn_4xlarge,
    r5dn_8xlarge,
    r5dn_12xlarge,
    r5dn_16xlarge,
    r5dn_24xlarge,
    r5dn_metal,
    r5n_large,
    r5n_xlarge,
    r5n_2xlarge,
    r5n_4xlarge,
    r5n_8xlarge,
    r5n_12xlarge,
    r5n_16xlarge,
    r5n_24xlarge,
    r5n_metal,
    r6g_medium,
    r6g_large,
    r6g_xlarge,
    r6g_2xlarge,
    r6g_4xlarge,
    r6g_8xlarge,
    r6g_12xlarge,
    r6g_16xlarge,
    r6g_metal,
    r6gd_medium,
    r6gd_large,
    r6gd_xlarge,
    r6gd_2xlarge,
    r6gd_4xlarge,
    r6gd_8xlarge,
    r6gd_12xlarge,
    r6gd_16xlarge,
    r6gd_metal,
    r6i_large,
    r6i_xlarge,
    r6i_2xlarge,
    r6i_4xlarge,
    r6i_8xlarge,
    r6i_12xlarge,
    r6i_16xlarge,
    r6i_24xlarge,
    r6i_32xlarge,
    r6i_metal,
    t1_micro,
    t2_nano,
    t2_micro,
    t2_small,
    t2_medium,
    t2_large,
    t2_xlarge,
    t2_2xlarge,
    t3_nano,
    t3_micro,
    t3_small,
    t3_medium,
    t3_large,
    t3_xlarge,
    t3_2xlarge,
    t3a_nano,
    t3a_micro,
    t3a_small,
    t3a_medium,
    t3a_large,
    t3a_xlarge,
    t3a_2xlarge,
    t4g_nano,
    t4g_micro,
    t4g_small,
    t4g_medium,
    t4g_large,
    t4g_xlarge,
    t4g_2xlarge,
    u_6tb1_56xlarge,
    u_6tb1_112xlarge,
    u_9tb1_112xlarge,
    u_12tb1_112xlarge,
    u_6tb1_metal,
    u_9tb1_metal,
    u_12tb1_metal,
    u_18tb1_metal,
    u_24tb1_metal,
    vt1_3xlarge,
    vt1_6xlarge,
    vt1_24xlarge,
    x1_16xlarge,
    x1_32xlarge,
    x1e_xlarge,
    x1e_2xlarge,
    x1e_4xlarge,
    x1e_8xlarge,
    x1e_16xlarge,
    x1e_32xlarge,
    x2iezn_2xlarge,
    x2iezn_4xlarge,
    x2iezn_6xlarge,
    x2iezn_8xlarge,
    x2iezn_12xlarge,
    x2iezn_metal,
    x2gd_medium,
    x2gd_large,
    x2gd_xlarge,
    x2gd_2xlarge,
    x2gd_4xlarge,
    x2gd_8xlarge,
    x2gd_12xlarge,
    x2gd_16xlarge,
    x2gd_metal,
    z1d_large,
    z1d_xlarge,
    z1d_2xlarge,
    z1d_3xlarge,
    z1d_6xlarge,
    z1d_12xlarge,
    z1d_metal,
    x2idn_16xlarge,
    x2idn_24xlarge,
    x2idn_32xlarge,
    x2iedn_xlarge,
    x2iedn_2xlarge,
    x2iedn_4xlarge,
    x2iedn_8xlarge,
    x2iedn_16xlarge,
    x2iedn_24xlarge,
    x2iedn_32xlarge,
    c6a_large,
    c6a_xlarge,
    c6a_2xlarge,
    c6a_4xlarge,
    c6a_8xlarge,
    c6a_12xlarge,
    c6a_16xlarge,
    c6a_24xlarge,
    c6a_32xlarge,
    c6a_48xlarge,
    c6a_metal,
    m6a_metal,
    i4i_large,
    i4i_xlarge,
    i4i_2xlarge,
    i4i_4xlarge,
    i4i_8xlarge,
    i4i_16xlarge,
    i4i_32xlarge,
    i4i_metal,
    x2idn_metal,
    x2iedn_metal,
    c7g_medium,
    c7g_large,
    c7g_xlarge,
    c7g_2xlarge,
    c7g_4xlarge,
    c7g_8xlarge,
    c7g_12xlarge,
    c7g_16xlarge,
    mac2_metal,
    c6id_large,
    c6id_xlarge,
    c6id_2xlarge,
    c6id_4xlarge,
    c6id_8xlarge,
    c6id_12xlarge,
    c6id_16xlarge,
    c6id_24xlarge,
    c6id_32xlarge,
    c6id_metal,
    m6id_large,
    m6id_xlarge,
    m6id_2xlarge,
    m6id_4xlarge,
    m6id_8xlarge,
    m6id_12xlarge,
    m6id_16xlarge,
    m6id_24xlarge,
    m6id_32xlarge,
    m6id_metal,
    r6id_large,
    r6id_xlarge,
    r6id_2xlarge,
    r6id_4xlarge,
    r6id_8xlarge,
    r6id_12xlarge,
    r6id_16xlarge,
    r6id_24xlarge,
    r6id_32xlarge,
    r6id_metal,
    r6a_large,
    r6a_xlarge,
    r6a_2xlarge,
    r6a_4xlarge,
    r6a_8xlarge,
    r6a_12xlarge,
    r6a_16xlarge,
    r6a_24xlarge,
    r6a_32xlarge,
    r6a_48xlarge,
    r6a_metal,
    p4de_24xlarge,
    u_3tb1_56xlarge,
    u_18tb1_112xlarge,
    u_24tb1_112xlarge,
    trn1_2xlarge,
    trn1_32xlarge,
    hpc6id_32xlarge,
    c6in_large,
    c6in_xlarge,
    c6in_2xlarge,
    c6in_4xlarge,
    c6in_8xlarge,
    c6in_12xlarge,
    c6in_16xlarge,
    c6in_24xlarge,
    c6in_32xlarge,
    m6in_large,
    m6in_xlarge,
    m6in_2xlarge,
    m6in_4xlarge,
    m6in_8xlarge,
    m6in_12xlarge,
    m6in_16xlarge,
    m6in_24xlarge,
    m6in_32xlarge,
    m6idn_large,
    m6idn_xlarge,
    m6idn_2xlarge,
    m6idn_4xlarge,
    m6idn_8xlarge,
    m6idn_12xlarge,
    m6idn_16xlarge,
    m6idn_24xlarge,
    m6idn_32xlarge,
    r6in_large,
    r6in_xlarge,
    r6in_2xlarge,
    r6in_4xlarge,
    r6in_8xlarge,
    r6in_12xlarge,
    r6in_16xlarge,
    r6in_24xlarge,
    r6in_32xlarge,
    r6idn_large,
    r6idn_xlarge,
    r6idn_2xlarge,
    r6idn_4xlarge,
    r6idn_8xlarge,
    r6idn_12xlarge,
    r6idn_16xlarge,
    r6idn_24xlarge,
    r6idn_32xlarge,
    c7g_metal,
    m7g_medium,
    m7g_large,
    m7g_xlarge,
    m7g_2xlarge,
    m7g_4xlarge,
    m7g_8xlarge,
    m7g_12xlarge,
    m7g_16xlarge,
    m7g_metal,
    r7g_medium,
    r7g_large,
    r7g_xlarge,
    r7g_2xlarge,
    r7g_4xlarge,
    r7g_8xlarge,
    r7g_12xlarge,
    r7g_16xlarge,
    r7g_metal,
    c6in_metal,
    m6in_metal,
    m6idn_metal,
    r6in_metal,
    r6idn_metal,
    inf2_xlarge,
    inf2_8xlarge,
    inf2_24xlarge,
    inf2_48xlarge,
    trn1n_32xlarge,
    i4g_large,
    i4g_xlarge,
    i4g_2xlarge,
    i4g_4xlarge,
    i4g_8xlarge,
    i4g_16xlarge,
    hpc7g_4xlarge,
    hpc7g_8xlarge,
    hpc7g_16xlarge,
    c7gn_medium,
    c7gn_large,
    c7gn_xlarge,
    c7gn_2xlarge,
    c7gn_4xlarge,
    c7gn_8xlarge,
    c7gn_12xlarge,
    c7gn_16xlarge,
    p5_48xlarge,
    m7i_large,
    m7i_xlarge,
    m7i_2xlarge,
    m7i_4xlarge,
    m7i_8xlarge,
    m7i_12xlarge,
    m7i_16xlarge,
    m7i_24xlarge,
    m7i_48xlarge,
    m7i_flex_large,
    m7i_flex_xlarge,
    m7i_flex_2xlarge,
    m7i_flex_4xlarge,
    m7i_flex_8xlarge,
    m7a_medium,
    m7a_large,
    m7a_xlarge,
    m7a_2xlarge,
    m7a_4xlarge,
    m7a_8xlarge,
    m7a_12xlarge,
    m7a_16xlarge,
    m7a_24xlarge,
    m7a_32xlarge,
    m7a_48xlarge,
    m7a_metal_48xl,
    hpc7a_12xlarge,
    hpc7a_24xlarge,
    hpc7a_48xlarge,
    hpc7a_96xlarge,
    c7gd_medium,
    c7gd_large,
    c7gd_xlarge,
    c7gd_2xlarge,
    c7gd_4xlarge,
    c7gd_8xlarge,
    c7gd_12xlarge,
    c7gd_16xlarge,
    m7gd_medium,
    m7gd_large,
    m7gd_xlarge,
    m7gd_2xlarge,
    m7gd_4xlarge,
    m7gd_8xlarge,
    m7gd_12xlarge,
    m7gd_16xlarge,
    r7gd_medium,
    r7gd_large,
    r7gd_xlarge,
    r7gd_2xlarge,
    r7gd_4xlarge,
    r7gd_8xlarge,
    r7gd_12xlarge,
    r7gd_16xlarge,
    r7a_medium,
    r7a_large,
    r7a_xlarge,
    r7a_2xlarge,
    r7a_4xlarge,
    r7a_8xlarge,
    r7a_12xlarge,
    r7a_16xlarge,
    r7a_24xlarge,
    r7a_32xlarge,
    r7a_48xlarge,
    c7i_large,
    c7i_xlarge,
    c7i_2xlarge,
    c7i_4xlarge,
    c7i_8xlarge,
    c7i_12xlarge,
    c7i_16xlarge,
    c7i_24xlarge,
    c7i_48xlarge,
    mac2_m2pro_metal,
    r7iz_large,
    r7iz_xlarge,
    r7iz_2xlarge,
    r7iz_4xlarge,
    r7iz_8xlarge,
    r7iz_12xlarge,
    r7iz_16xlarge,
    r7iz_32xlarge,
    c7a_medium,
    c7a_large,
    c7a_xlarge,
    c7a_2xlarge,
    c7a_4xlarge,
    c7a_8xlarge,
    c7a_12xlarge,
    c7a_16xlarge,
    c7a_24xlarge,
    c7a_32xlarge,
    c7a_48xlarge,
    c7a_metal_48xl,
    r7a_metal_48xl,
    r7i_large,
    r7i_xlarge,
    r7i_2xlarge,
    r7i_4xlarge,
    r7i_8xlarge,
    r7i_12xlarge,
    r7i_16xlarge,
    r7i_24xlarge,
    r7i_48xlarge,
    dl2q_24xlarge,
    mac2_m2_metal,
    i4i_12xlarge,
    i4i_24xlarge,
    c7i_metal_24xl,
    c7i_metal_48xl,
    m7i_metal_24xl,
    m7i_metal_48xl,
    r7i_metal_24xl,
    r7i_metal_48xl,
    r7iz_metal_16xl,
    r7iz_metal_32xl,
    c7gd_metal,
    m7gd_metal,
    r7gd_metal,
    g6_xlarge,
    g6_2xlarge,
    g6_4xlarge,
    g6_8xlarge,
    g6_12xlarge,
    g6_16xlarge,
    g6_24xlarge,
    g6_48xlarge,
    gr6_4xlarge,
    gr6_8xlarge,
    c7i_flex_large,
    c7i_flex_xlarge,
    c7i_flex_2xlarge,
    c7i_flex_4xlarge,
    c7i_flex_8xlarge,
    u7i_12tb_224xlarge,
    u7in_16tb_224xlarge,
    u7in_24tb_224xlarge,
    u7in_32tb_224xlarge,
    u7ib_12tb_224xlarge,
    c7gn_metal,
    r8g_medium,
    r8g_large,
    r8g_xlarge,
    r8g_2xlarge,
    r8g_4xlarge,
    r8g_8xlarge,
    r8g_12xlarge,
    r8g_16xlarge,
    r8g_24xlarge,
    r8g_48xlarge,
    r8g_metal_24xl,
    r8g_metal_48xl,
    mac2_m1ultra_metal,
    g6e_xlarge,
    g6e_2xlarge,
    g6e_4xlarge,
    g6e_8xlarge,
    g6e_12xlarge,
    g6e_16xlarge,
    g6e_24xlarge,
    g6e_48xlarge,
    c8g_medium,
    c8g_large,
    c8g_xlarge,
    c8g_2xlarge,
    c8g_4xlarge,
    c8g_8xlarge,
    c8g_12xlarge,
    c8g_16xlarge,
    c8g_24xlarge,
    c8g_48xlarge,
    c8g_metal_24xl,
    c8g_metal_48xl,
    m8g_medium,
    m8g_large,
    m8g_xlarge,
    m8g_2xlarge,
    m8g_4xlarge,
    m8g_8xlarge,
    m8g_12xlarge,
    m8g_16xlarge,
    m8g_24xlarge,
    m8g_48xlarge,
    m8g_metal_24xl,
    m8g_metal_48xl,
    x8g_medium,
    x8g_large,
    x8g_xlarge,
    x8g_2xlarge,
    x8g_4xlarge,
    x8g_8xlarge,
    x8g_12xlarge,
    x8g_16xlarge,
    x8g_24xlarge,
    x8g_48xlarge,
    x8g_metal_24xl,
    x8g_metal_48xl,
    i7ie_large,
    i7ie_xlarge,
    i7ie_2xlarge,
    i7ie_3xlarge,
    i7ie_6xlarge,
    i7ie_12xlarge,
    i7ie_18xlarge,
    i7ie_24xlarge,
    i7ie_48xlarge,
    i8g_large,
    i8g_xlarge,
    i8g_2xlarge,
    i8g_4xlarge,
    i8g_8xlarge,
    i8g_12xlarge,
    i8g_16xlarge,
    i8g_24xlarge,
    i8g_metal_24xl,
    u7i_6tb_112xlarge,
    u7i_8tb_112xlarge,
    u7inh_32tb_480xlarge,
    p5e_48xlarge,
    p5en_48xlarge,
    f2_12xlarge,
    f2_48xlarge,
    trn2_48xlarge,
    c7i_flex_12xlarge,
    c7i_flex_16xlarge,
    m7i_flex_12xlarge,
    m7i_flex_16xlarge,
    i7ie_metal_24xl,
    i7ie_metal_48xl,
    i8g_48xlarge,
    c8gd_medium,
    c8gd_large,
    c8gd_xlarge,
    c8gd_2xlarge,
    c8gd_4xlarge,
    c8gd_8xlarge,
    c8gd_12xlarge,
    c8gd_16xlarge,
    c8gd_24xlarge,
    c8gd_48xlarge,
    c8gd_metal_24xl,
    c8gd_metal_48xl,
    i7i_large,
    i7i_xlarge,
    i7i_2xlarge,
    i7i_4xlarge,
    i7i_8xlarge,
    i7i_12xlarge,
    i7i_16xlarge,
    i7i_24xlarge,
    i7i_48xlarge,
    i7i_metal_24xl,
    i7i_metal_48xl,
    p6_b200_48xlarge,
    m8gd_medium,
    m8gd_large,
    m8gd_xlarge,
    m8gd_2xlarge,
    m8gd_4xlarge,
    m8gd_8xlarge,
    m8gd_12xlarge,
    m8gd_16xlarge,
    m8gd_24xlarge,
    m8gd_48xlarge,
    m8gd_metal_24xl,
    m8gd_metal_48xl,
    r8gd_medium,
    r8gd_large,
    r8gd_xlarge,
    r8gd_2xlarge,
    r8gd_4xlarge,
    r8gd_8xlarge,
    r8gd_12xlarge,
    r8gd_16xlarge,
    r8gd_24xlarge,
    r8gd_48xlarge,
    r8gd_metal_24xl,
    r8gd_metal_48xl,
    c8gn_medium,
    c8gn_large,
    c8gn_xlarge,
    c8gn_2xlarge,
    c8gn_4xlarge,
    c8gn_8xlarge,
    c8gn_12xlarge,
    c8gn_16xlarge,
    c8gn_24xlarge,
    c8gn_48xlarge,
    c8gn_metal_24xl,
    c8gn_metal_48xl,
    f2_6xlarge,
    p6e_gb200_36xlarge,
    g6f_large,
    g6f_xlarge,
    g6f_2xlarge,
    g6f_4xlarge,
    gr6f_4xlarge,
    p5_4xlarge,
    r8i_large,
    r8i_xlarge,
    r8i_2xlarge,
    r8i_4xlarge,
    r8i_8xlarge,
    r8i_12xlarge,
    r8i_16xlarge,
    r8i_24xlarge,
    r8i_32xlarge,
    r8i_48xlarge,
    r8i_96xlarge,
    r8i_metal_48xl,
    r8i_metal_96xl,
    r8i_flex_large,
    r8i_flex_xlarge,
    r8i_flex_2xlarge,
    r8i_flex_4xlarge,
    r8i_flex_8xlarge,
    r8i_flex_12xlarge,
    r8i_flex_16xlarge,
    m8i_large,
    m8i_xlarge,
    m8i_2xlarge,
    m8i_4xlarge,
    m8i_8xlarge,
    m8i_12xlarge,
    m8i_16xlarge,
    m8i_24xlarge,
    m8i_32xlarge,
    m8i_48xlarge,
    m8i_96xlarge,
    m8i_metal_48xl,
    m8i_metal_96xl,
    m8i_flex_large,
    m8i_flex_xlarge,
    m8i_flex_2xlarge,
    m8i_flex_4xlarge,
    m8i_flex_8xlarge,
    m8i_flex_12xlarge,
    m8i_flex_16xlarge,
    i8ge_large,
    i8ge_xlarge,
    i8ge_2xlarge,
    i8ge_3xlarge,
    i8ge_6xlarge,
    i8ge_12xlarge,
    i8ge_18xlarge,
    i8ge_24xlarge,
    i8ge_48xlarge,
    i8ge_metal_24xl,
    i8ge_metal_48xl,
    mac_m4_metal,
    mac_m4pro_metal,
    r8gn_medium,
    r8gn_large,
    r8gn_xlarge,
    r8gn_2xlarge,
    r8gn_4xlarge,
    r8gn_8xlarge,
    r8gn_12xlarge,
    r8gn_16xlarge,
    r8gn_24xlarge,
    r8gn_48xlarge,
    r8gn_metal_24xl,
    r8gn_metal_48xl
  };

namespace InstanceTypeMapper
{
AWS_EC2_API InstanceType GetInstanceTypeForName(const Aws::String& name);

AWS_EC2_API Aws::String GetNameForInstanceType(InstanceType value);
} // namespace InstanceTypeMapper
} // namespace Model
} // namespace EC2
} // namespace Aws
